use core;
use core:debug;
use lang:bs:macro;

// Declare a named thread. Threads are a special kind of global variables, since
// the compiler have to impose stricter checks on threads compared to regular global
// variables. For example, a named thread may not mutate like a global variable may do
// in some cases during updates. This would break thread-safety.
thread Other;

// Should be able to access threads as regular values.
Thread getThread() {
	Other;
}

Thread getCompilerThread() {
	Compiler;
}

Int postInt() {
	otherIntFn(1);
}

Int otherIntFn(Int v) on Other {
	8 + v;
}

Int postDbgVal() {
	DbgVal val(10);
	otherDbgValFn(val);
}

Int otherDbgValFn(DbgVal v) on Other {
	8 + v.get;
}

Int postObject() {
	CloneDerived d;
	CloneDerived z = otherObjectFn(d);
    // Should be 13. d is copied 2 times.
	if (disjoint(d, z)) {
		z.c;
	} else {
		0;
	}
}

CloneDerived otherObjectFn(CloneDerived o) on Other {
	o.c = o.c + o.a + o.b.get;
	o;
}

// Try with a value as well!
value ThreadVal {
	CloneDerived v;
	Int z;

	init() {
		init() {
			z = 10;
			v();
		}
	}

}

Int postVal() {
	ThreadVal v;
	ThreadVal r = otherValFn(v);
	if (disjoint(v.v, r.v)) {
		r.v.c + r.z;
	} else {
		0;
	}
}

ThreadVal otherValFn(ThreadVal v) on Other {
	v.v = otherObjectFn(v.v);
	v.z = 20;
	v;
}

Int postMaybeVal() {
	ThreadVal v;
	ThreadVal? maybe = v;
	ThreadVal r = otherMaybeValFn(maybe);
	if (disjoint(v.v, r.v)) {
		r.v.c + r.z;
	} else {
		0;
	}
}

ThreadVal otherMaybeValFn(ThreadVal? v) on Other {
	if (v) {
		v.v = otherObjectFn(v.v);
		v.z = 20;
		v;
	} else {
		ThreadVal();
	}
}


class ThreadObj on Other {
	Int v;

	Int get() {
		v;
	}

	void set(Int z) {
		v = z;
	}
}

class DynActor on ? {
	Int v;

	init(Thread) {
		init();
	}

	Int get() {
		v;
	}

	void set(Int z) {
		v = z;
	}
}

class DerDynActor extends DynActor {
	init(Thread, Int initial) {
		init();
		set(initial);
	}
}

// This would not work unless 'o' is a threaded object.
void setValue(ThreadObj o) on Other {
	o.set(20);
}

void setValue(DbgActor o, Int to) on Other {
	o.set(to);
}

void setValue(DynActor o, Int to) on Other {
	o.set(to);
}

Int findValue(ThreadObj o) on Other {
	o.get;
}

Int findValue(DbgActor o) on Other {
	o.get;
}

Int findValue(DynActor o) on Other {
	o.get;
}

Int threadObj() {
	ThreadObj z;
	setValue(z);
	findValue(z);
}

Int threadActor() {
	DbgActor a(10);
	setValue(a, 20);
	findValue(a);
}

Int actorObj() {
	DynActor z = DynActor(Other);
	setValue(z, 31);
	findValue(z);
}

Int actorDerObj() {
	DynActor z = DerDynActor(Other, 22);
	findValue(z);
}

// Test some future magic!
Int basicFuture() {
	CloneDerived original;
	Future<CloneDerived> fut;
	fut.post(original);
	CloneDerived c = fut.result;
	CloneDerived d = fut.result;
	if (disjoint(original, c)) {
		// These should be different as well!
		if (disjoint(c, d)) {
			c.c;
		} else {
			0;
		}
	} else {
		0;
	}
}

Int valueFuture() {
	CloneVal val;
	Future<CloneVal> fut;
	fut.post(val);
	CloneVal r = fut.result;

	if (disjoint(val.z, r.z)) {
		r.z.get;
	} else {
		0;
	}
}

Int intFuture() {
	Future<Int> fut;
	fut.post(22);
	fut.result;
}

void noResultFuture() {
	Future<CloneVal> fut;
	fut.post(CloneVal());
	// We're never getting the result back, make sure we do not crash too badly at least!
}

// Test spawn-async.
Int asyncPostInt() {
	var r = spawn otherIntFn(1);
	r.result;
}

Int asyncPostObject() {
	CloneDerived d;
	var f = spawn otherObjectFn(d);
	CloneDerived z = f.result;
	if (disjoint(d, z)) {
		z.c;
	} else {
		0;
	}
}

Int asyncPostObject2() {
	CloneDerived d;
	// Alternate syntax
	var f = spawn d.otherObjectFn();
	CloneDerived z = f.result;
	if (disjoint(d, z)) {
		z.c;
	} else {
		0;
	}
}

Int asyncPostVal() {
	ThreadVal v;
	ThreadVal r = (spawn otherValFn(v)).result;
	if (disjoint(v.v, r.v)) {
		r.v.c + r.z;
	} else {
		0;
	}
}

Int asyncObject() {
	CloneDerived d;
	var fut = spawn otherObjectFn(d);
	CloneDerived z = fut.result;
    // Should be 13. d is copied 3 times.
	if (disjoint(d, z)) {
		z.c;
	} else {
		0;
	}
}

void voidThreadFn() on Other {
	// Nothing here!
}

void spawnVoid() {
	var fut = spawn voidThreadFn();
	fut.result;
}

Int captureVal(CloneDerived v) {
	v.c;
}

Int captureValO(CloneDerived v) on Other {
	v.c;
}

CloneDerived returnVal() {
	CloneDerived();
}

Int asyncPostSame() {
	CloneDerived v;
	var future = spawn captureVal(v);
	future.result;
}

Int asyncReturnSame() {
	var future = spawn returnVal();
	future.result.c;
}

Int asyncPostSameThread() {
	asyncPostSameI();
}

Int asyncPostSameI() on Other {
	CloneDerived v;
	var future = spawn captureValO(v);
	future.result;
}

Int asyncPostExplicit() {
	CloneDerived v;
	var future = spawn(Other) captureVal(v);
	future.result;
}

void asyncPostExplictError() {
	CloneDerived v;
	// Should cause an error:
	spawn(Compiler) captureValO(v);
}

class ActorVar on Other {
	// Public value that we will try to get from another thread.
	CloneDerived value;

	init() {
		init();
	}
}

Int threadVarAccess() {
	// Try to access a variable inside an object on another thread. We should receive a clone!
	ActorVar o;
	o.value.c;
}

void threadVarAssign() {
	// This does not currently work, and the compiler should tell us that.
	ActorVar o;
	o.value = CloneDerived();
}


class OnOther on Other {
	Int echo(CloneDerived x) {
		x.c;
	}

	// Similar to 'customThis', but actually a member.
	Int defaultThis() {
		CloneDerived d;
		echo(d);
	}
}

Int customThis() {
	CloneDerived d;
	OnOther this;

	// The compiler must see that we *need* a copy here, even though we use an implicit "this".
	echo(d);
}

Int defaultThis() {
	OnOther z;
	z.defaultThis();
}
