
(define-module (intr-gtk4-examples calc2 plugin-dialog-impl)

  #:use-module (oop goops)
  #:use-module (g-golf)
  #:use-module (intr-gtk4-examples calc2 current-filename)

  #:duplicates (merge-generics
                replace
                warn-override-core
                warn
                last)

  #:export (<plugin-dialog>))


(define %module-path
  (dirname (my-current-filename)))
  ;; ".")

(eval-when (expand load eval)

  (g-irepository-require "Gtk" #:version "4.0")

  (for-each (lambda (name)
              (gi-import-by-name "Gtk" name))
      '("Window"
        "Button"
        "StringList"
        "Image")))


(define-class <plugin-dialog> (<gtk-window>)
  (dropdown-plugin #:child-id "dropdown-plugin")
  (entry-proc #:child-id "entry-proc")
  (entry-nargs #:child-id "entry-nargs")
  ;; (stringlist-plugin #:child-id "stringlist-plugin")
  (buffer-proc #:child-id "buffer-proc")
  (buffer-nargs #:child-id "buffer-nargs")
  (checkbutton-normal-var #:child-id "checkbutton-normal-var")
  (checkbutton-ngp #:child-id "checkbutton-ngp")
  (checkbutton-vgp #:child-id "checkbutton-vgp")
  (button-ok #:child-id "button-ok")
  (button-cancel #:child-id "button-cancel")

  #:template (string-append %module-path
                            "/plugin-dialog-ui.ui")

  #:child-ids '("dropdown-plugin"
                "entry-proc"
                "entry-nargs"
                ;; "stringlist-plugin"
                "buffer-proc"
                "buffer-nargs"
                "checkbutton-normal-var"
                "checkbutton-ngp"
                "checkbutton-vgp"
                "button-ok"
                "button-cancel"))


(define-public (plugin-dialog-new)
  (make <plugin-dialog>))

