/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageBlit2;

public class VkBlitImageInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;
    public static final int FILTER;

    public VkBlitImageInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBlitImageInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBlitImageInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBlitImageInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkBlitImageInfo2.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkBlitImageInfo2.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkBlitImageInfo2.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkBlitImageInfo2.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkBlitImageInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkImageBlit2 const *")
    public VkImageBlit2.Buffer pRegions() {
        return VkBlitImageInfo2.npRegions(this.address());
    }

    @NativeType(value="VkFilter")
    public int filter() {
        return VkBlitImageInfo2.nfilter(this.address());
    }

    public VkBlitImageInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkBlitImageInfo2.nsType(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 sType$Default() {
        return this.sType(1000337004);
    }

    public VkBlitImageInfo2 pNext(@NativeType(value="void const *") long value) {
        VkBlitImageInfo2.npNext(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 srcImage(@NativeType(value="VkImage") long value) {
        VkBlitImageInfo2.nsrcImage(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkBlitImageInfo2.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 dstImage(@NativeType(value="VkImage") long value) {
        VkBlitImageInfo2.ndstImage(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkBlitImageInfo2.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 pRegions(@NativeType(value="VkImageBlit2 const *") VkImageBlit2.Buffer value) {
        VkBlitImageInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 filter(@NativeType(value="VkFilter") int value) {
        VkBlitImageInfo2.nfilter(this.address(), value);
        return this;
    }

    public VkBlitImageInfo2 set(int sType, long pNext, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageBlit2.Buffer pRegions, int filter) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        this.filter(filter);
        return this;
    }

    public VkBlitImageInfo2 set(VkBlitImageInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBlitImageInfo2 malloc() {
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBlitImageInfo2 calloc() {
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBlitImageInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBlitImageInfo2 create(long address) {
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)address);
    }

    @Nullable
    public static VkBlitImageInfo2 createSafe(long address) {
        return address == 0L ? null : (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBlitImageInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBlitImageInfo2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBlitImageInfo2 malloc(MemoryStack stack) {
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBlitImageInfo2 calloc(MemoryStack stack) {
        return (VkBlitImageInfo2)VkBlitImageInfo2.wrap(VkBlitImageInfo2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBlitImageInfo2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static long ndstImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTIMAGE);
    }

    public static int ndstImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkImageBlit2.Buffer npRegions(long struct) {
        return VkImageBlit2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkBlitImageInfo2.nregionCount(struct));
    }

    public static int nfilter(long struct) {
        return UNSAFE.getInt(null, struct + (long)FILTER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void ndstImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTIMAGE, value);
    }

    public static void ndstImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkImageBlit2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkBlitImageInfo2.nregionCount(struct, value.remaining());
    }

    public static void nfilter(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FILTER, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkBlitImageInfo2.__struct((Struct.Member[])new Struct.Member[]{VkBlitImageInfo2.__member((int)4), VkBlitImageInfo2.__member((int)POINTER_SIZE), VkBlitImageInfo2.__member((int)8), VkBlitImageInfo2.__member((int)4), VkBlitImageInfo2.__member((int)8), VkBlitImageInfo2.__member((int)4), VkBlitImageInfo2.__member((int)4), VkBlitImageInfo2.__member((int)POINTER_SIZE), VkBlitImageInfo2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCIMAGE = layout.offsetof(2);
        SRCIMAGELAYOUT = layout.offsetof(3);
        DSTIMAGE = layout.offsetof(4);
        DSTIMAGELAYOUT = layout.offsetof(5);
        REGIONCOUNT = layout.offsetof(6);
        PREGIONS = layout.offsetof(7);
        FILTER = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBlitImageInfo2, Buffer>
    implements NativeResource {
        private static final VkBlitImageInfo2 ELEMENT_FACTORY = VkBlitImageInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBlitImageInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBlitImageInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBlitImageInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkBlitImageInfo2.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkBlitImageInfo2.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkBlitImageInfo2.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkBlitImageInfo2.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkBlitImageInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkImageBlit2 const *")
        public VkImageBlit2.Buffer pRegions() {
            return VkBlitImageInfo2.npRegions(this.address());
        }

        @NativeType(value="VkFilter")
        public int filter() {
            return VkBlitImageInfo2.nfilter(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBlitImageInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBlitImageInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkBlitImageInfo2.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkBlitImageInfo2.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkBlitImageInfo2.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkBlitImageInfo2.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageBlit2 const *") VkImageBlit2.Buffer value) {
            VkBlitImageInfo2.npRegions(this.address(), value);
            return this;
        }

        public Buffer filter(@NativeType(value="VkFilter") int value) {
            VkBlitImageInfo2.nfilter(this.address(), value);
            return this;
        }
    }
}

