/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_bus_address_amd")
public class CLBusAddressAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SURFBUSADDRESS;
    public static final int SIGNALBUSADDRESS;

    public CLBusAddressAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLBusAddressAMD.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_long")
    public long surfbusaddress() {
        return CLBusAddressAMD.nsurfbusaddress(this.address());
    }

    @NativeType(value="cl_long")
    public long signalbusaddress() {
        return CLBusAddressAMD.nsignalbusaddress(this.address());
    }

    public CLBusAddressAMD surfbusaddress(@NativeType(value="cl_long") long value) {
        CLBusAddressAMD.nsurfbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD signalbusaddress(@NativeType(value="cl_long") long value) {
        CLBusAddressAMD.nsignalbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD set(long surfbusaddress, long signalbusaddress) {
        this.surfbusaddress(surfbusaddress);
        this.signalbusaddress(signalbusaddress);
        return this;
    }

    public CLBusAddressAMD set(CLBusAddressAMD src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CLBusAddressAMD malloc() {
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CLBusAddressAMD calloc() {
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CLBusAddressAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CLBusAddressAMD create(long address) {
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)address);
    }

    @Nullable
    public static CLBusAddressAMD createSafe(long address) {
        return address == 0L ? null : (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CLBusAddressAMD.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLBusAddressAMD.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CLBusAddressAMD mallocStack() {
        return CLBusAddressAMD.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBusAddressAMD callocStack() {
        return CLBusAddressAMD.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBusAddressAMD mallocStack(MemoryStack stack) {
        return CLBusAddressAMD.malloc(stack);
    }

    @Deprecated
    public static CLBusAddressAMD callocStack(MemoryStack stack) {
        return CLBusAddressAMD.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLBusAddressAMD.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLBusAddressAMD.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.calloc(capacity, stack);
    }

    public static CLBusAddressAMD malloc(MemoryStack stack) {
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBusAddressAMD calloc(MemoryStack stack) {
        return (CLBusAddressAMD)CLBusAddressAMD.wrap(CLBusAddressAMD.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CLBusAddressAMD.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsurfbusaddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SURFBUSADDRESS);
    }

    public static long nsignalbusaddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIGNALBUSADDRESS);
    }

    public static void nsurfbusaddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SURFBUSADDRESS, value);
    }

    public static void nsignalbusaddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIGNALBUSADDRESS, value);
    }

    static {
        Struct.Layout layout = CLBusAddressAMD.__struct((Struct.Member[])new Struct.Member[]{CLBusAddressAMD.__member((int)8), CLBusAddressAMD.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SURFBUSADDRESS = layout.offsetof(0);
        SIGNALBUSADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBusAddressAMD, Buffer>
    implements NativeResource {
        private static final CLBusAddressAMD ELEMENT_FACTORY = CLBusAddressAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CLBusAddressAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_long")
        public long surfbusaddress() {
            return CLBusAddressAMD.nsurfbusaddress(this.address());
        }

        @NativeType(value="cl_long")
        public long signalbusaddress() {
            return CLBusAddressAMD.nsignalbusaddress(this.address());
        }

        public Buffer surfbusaddress(@NativeType(value="cl_long") long value) {
            CLBusAddressAMD.nsurfbusaddress(this.address(), value);
            return this;
        }

        public Buffer signalbusaddress(@NativeType(value="cl_long") long value) {
            CLBusAddressAMD.nsignalbusaddress(this.address(), value);
            return this;
        }
    }
}

