/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.router.crypto.ratchet.ArrayUtils;

final class GrowingArrayUtils {
    public static <T> T[] append(T[] array, int currentSize, T element) {
        assert (currentSize <= array.length);
        if (currentSize + 1 > array.length) {
            ?[] newArray = ArrayUtils.newUnpaddedArray(array.getClass().getComponentType(), GrowingArrayUtils.growSize(currentSize));
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    public static char[] append(char[] array, int currentSize, char element) {
        assert (currentSize <= array.length);
        if (currentSize + 1 > array.length) {
            char[] newArray = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(currentSize));
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    public static <T> T[] insert(T[] array, int currentSize, int index, T element) {
        assert (currentSize <= array.length);
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        ?[] newArray = ArrayUtils.newUnpaddedArray(array.getClass().getComponentType(), GrowingArrayUtils.growSize(currentSize));
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static char[] insert(char[] array, int currentSize, int index, char element) {
        assert (currentSize <= array.length);
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        char[] newArray = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(currentSize));
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static int growSize(int currentSize) {
        return currentSize <= 4 ? 8 : currentSize * 2;
    }

    private GrowingArrayUtils() {
    }
}

