#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - A managed alloydb cluster instance.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_alloydb_instance
notes:
  - 'API Reference: U(https://cloud.google.com/alloydb/docs/reference/rest/v1/projects.locations.clusters.instances/create)'
  - 'AlloyDB Guide: U(https://cloud.google.com/alloydb/docs/)'
options:
  activation_policy:
    choices:
      - ACTIVATION_POLICY_UNSPECIFIED
      - ALWAYS
      - NEVER
    description:
      - '''Specifies whether an instance needs to spin up.'
      - Once the instance is active, the activation policy can be updated to the `NEVER` to stop the instance.
      - Likewise, the activation policy can be updated to `ALWAYS` to start the instance.
      - >-
        There are restrictions around when an instance can/cannot be activated (for example, a read pool instance should be stopped before stopping

        primary etc.).
      - Please refer to the API documentation for more details.
      - 'Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.''.'
    type: str
  annotations:
    description:
      - Annotations to allow client tools to store small amount of arbitrary data.
      - This is distinct from labels.
    type: dict
  availability_type:
    choices:
      - AVAILABILITY_TYPE_UNSPECIFIED
      - ZONAL
      - REGIONAL
    description:
      - '''Availability type of an Instance.'
      - Defaults to REGIONAL for both primary and read instances.
      - Note that primary and read instances can have different availability types.
      - Primary instances can be either ZONAL or REGIONAL.
      - Read Pool instances can also be either ZONAL or REGIONAL.
      - Read pools of size 1 can only have zonal availability.
      - Read pools with a node count of 2 or more can have regional availability (nodes are present in 2 or more zones in a region).
      - 'Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.''.'
    type: str
  client_connection_config:
    description:
      - Client connection specific configurations.
    suboptions:
      require_connectors:
        description:
          - 'Configuration to enforce connectors only (ex: AuthProxy) connections to the database.'
        type: bool
      ssl_config:
        description:
          - SSL config option for this instance.
        suboptions:
          ssl_mode:
            choices:
              - ENCRYPTED_ONLY
              - ALLOW_UNENCRYPTED_AND_ENCRYPTED
            description:
              - SSL mode.
              - Specifies client-server SSL/TLS connection behavior.
            type: str
        type: dict
    type: dict
  cluster:
    description:
      - Identifies the alloydb cluster.
      - Must be in the format 'projects/{project}/locations/{location}/clusters/{cluster_id}'.
      - This field is a reference to a Cluster resource in GCP.
      - 'It can be specified in two ways: First, you can place a dictionary with key ''name'' matching your resource.'
      - 'Alternatively, you can add `register: name-of-resource` to a Cluster task and then set this field to `{{ name-of-resource }}`.'
    required: true
    type: dict
  database_flags:
    description:
      - Database flags.
      - Set at instance level.
      - '* They are copied from primary instance on read instance creation.'
      - '* Read instances can set new or override existing flags that are relevant for reads, e.g.'
      - for enabling columnar cache on a read instance.
      - Flags set on read instance may or may not be present on primary.
    type: dict
  display_name:
    description:
      - User-settable and human-readable display name for the Instance.
    type: str
  gce_zone:
    description:
      - >-
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be

        specified for ZONAL instances.
      - If present for a REGIONAL instance, an error will be thrown.
      - If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
    type: str
  instance_id:
    description:
      - The ID of the alloydb instance.
    required: true
    type: str
  instance_type:
    choices:
      - PRIMARY
      - READ_POOL
      - SECONDARY
    description:
      - The type of the instance.
      - If the instance type is SECONDARY, point to the cluster_type of the associated secondary cluster instead of mentioning SECONDARY.
    required: true
    type: str
  labels:
    description:
      - User-defined labels for the alloydb instance.
    type: dict
  machine_config:
    description:
      - Configurations for the machines that host the underlying database engine.
    suboptions:
      cpu_count:
        description:
          - The number of CPU's in the VM instance.
        type: int
      machine_type:
        description:
          - Machine type of the VM instance.
          - E.g.
          - '"n2-highmem-4", "n2-highmem-8", "c4a-highmem-4-lssd".'
          - '`cpu_count` must match the number of vCPUs in the machine type.'
        type: str
    type: dict
  network_config:
    description:
      - Instance level network configuration.
    suboptions:
      authorized_external_networks:
        description:
          - A list of external networks authorized to access this instance.
          - This field is only allowed to be set when `enable_public_ip` is set to true.
        elements: dict
        suboptions:
          cidr_range:
            description:
              - CIDR range for one authorized network of the instance.
            type: str
        type: list
      enable_outbound_public_ip:
        description:
          - Enabling outbound public ip for the instance.
        type: bool
      enable_public_ip:
        description:
          - Enabling public ip for the instance.
          - If a user wishes to disable this, please also clear the list of the authorized external networks set on the same instance.
        type: bool
    type: dict
  observability_config:
    description:
      - Configuration for enhanced query insights.
    suboptions:
      assistive_experiences_enabled:
        description:
          - Whether assistive experiences are enabled for this AlloyDB instance.
        type: bool
      enabled:
        description:
          - Observability feature status for an instance.
        type: bool
      max_query_string_length:
        description:
          - Query string length.
          - The default value is 10240.
          - Any integer between 1024 and 100000 is considered valid.
        type: int
      preserve_comments:
        description:
          - Preserve comments in the query string.
        type: bool
      query_plans_per_minute:
        description:
          - Number of query execution plans captured by Insights per minute for all queries combined.
          - The default value is 5.
          - Any integer between 0 and 200 is considered valid.
        type: int
      record_application_tags:
        description:
          - Record application tags for an instance.
          - This flag is turned "on" by default.
        type: bool
      track_active_queries:
        description:
          - Track actively running queries.
          - If not set, default value is "off".
        type: bool
      track_wait_event_types:
        description:
          - Record wait event types during query execution for an instance.
        type: bool
      track_wait_events:
        description:
          - Record wait events during query execution for an instance.
        type: bool
    type: dict
  psc_instance_config:
    description:
      - Configuration for Private Service Connect (PSC) for the instance.
    suboptions:
      allowed_consumer_projects:
        description:
          - List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
          - These should be specified as project numbers only.
        elements: str
        type: list
      psc_auto_connections:
        description:
          - Configurations for setting up PSC service automation.
        elements: dict
        suboptions:
          consumer_network:
            description:
              - 'The consumer network for the PSC service automation, example: "projects/vpc-host-project/global/networks/default".'
              - The consumer network might be hosted a different project than the consumer project.
              - The API expects the consumer project specified to be the project ID (and not the project number).
            type: str
          consumer_network_status:
            description:
              - The status of the service connection policy.
            type: str
          consumer_project:
            description:
              - The consumer project to which the PSC service automation endpoint will be created.
              - The API expects the consumer project to be the project ID( and not the project number).
            type: str
          ip_address:
            description:
              - The IP address of the PSC service automation endpoint.
            type: str
          status:
            description:
              - The status of the PSC service automation connection.
            type: str
        type: list
      psc_dns_name:
        description:
          - The DNS name of the instance for PSC connectivity.
          - 'Name convention: <uid>.<uid>.<region>.alloydb-psc.goog.'
        type: str
      psc_interface_configs:
        description:
          - Configurations for setting up PSC interfaces attached to the instance which are used for outbound connectivity.
          - Currently, AlloyDB supports only 0 or 1 PSC interface.
        elements: dict
        suboptions:
          network_attachment_resource:
            description:
              - The network attachment resource created in the consumer project to which the PSC interface will be linked.
              - 'This is of the format: "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".'
              - The network attachment must be in the same region as the instance.
            type: str
        type: list
      service_attachment_link:
        description:
          - The service attachment created when Private Service Connect (PSC) is enabled for the instance.
          - >-
            The name of the resource will be in the format of

            `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`.
        type: str
    type: dict
  query_insights_config:
    description:
      - Configuration for query insights.
    suboptions:
      query_plans_per_minute:
        description:
          - Number of query execution plans captured by Insights per minute for all queries combined.
          - The default value is 5.
          - Any integer between 0 and 20 is considered valid.
        type: int
      query_string_length:
        description:
          - Query string length.
          - The default value is 1024.
          - Any integer between 256 and 4500 is considered valid.
        type: int
      record_application_tags:
        description:
          - Record application tags for an instance.
          - This flag is turned "on" by default.
        type: bool
      record_client_address:
        description:
          - Record client address for an instance.
          - Client address is PII information.
          - This flag is turned "on" by default.
        type: bool
    type: dict
  read_pool_config:
    description:
      - Read pool specific config.
      - If the instance type is READ_POOL, this configuration must be provided.
    suboptions:
      node_count:
        description:
          - Read capacity, i.e.
          - number of nodes in a read pool instance.
        type: int
    type: dict
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP Alloydb.Instance resource
"""

EXAMPLES = r"""
- name: Create a basic primary alloydb instance
  google.cloud.gcp_alloydb_instance:
    instance_id: "{{ resource_name }}"
    state: present
    location: us-central1
    instance_type: PRIMARY
    cluster:
      name: "projects/{{ gcp_project_number }}/locations/us-central1/clusters/{{ resource_name }}-cluster"
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
"""

RETURN = r"""
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
createTime:
  description:
    - Time the Instance was created in UTC.
  returned: success
  type: str
ipAddress:
  description:
    - The IP address for the Instance.
    - This is the connection endpoint for an end-user application.
  returned: success
  type: str
name:
  description:
    - The name of the instance resource.
  returned: success
  type: str
outboundPublicIpAddresses:
  description:
    - The outbound public IP addresses for the instance.
    - This is available ONLY when networkConfig.enableOutboundPublicIp is set to true.
    - These IP addresses are used for outbound connections.
  elements: str
  returned: success
  type: list
publicIpAddress:
  description:
    - The public IP addresses for the Instance.
    - This is available ONLY when networkConfig.enablePublicIp is set to true.
    - This is the connection endpoint for an end-user application.
  returned: success
  type: str
reconciling:
  description:
    - >-
      Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to

      reconcile them.
    - This can happen due to user-triggered updates or system actions like failover or maintenance.
  returned: success
  type: bool
state:
  description:
    - The current state of the alloydb instance.
  returned: success
  type: str
uid:
  description:
    - The system-generated UID of the resource.
  returned: success
  type: str
updateTime:
  description:
    - Time the Instance was updated in UTC.
  returned: success
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp

# BEGIN Custom imports
# None
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()
    params["cluster"] = gcp.replace_resource_dict(module.params["cluster"], "name")

    return "https://alloydb.googleapis.com/v1/" + uri.format(**params)


class ClientConnectionConfig(gcp.Resource):
    def _request(self):
        return {
            "requireConnectors": self.request.get("require_connectors"),
            "sslConfig": ClientConnectionConfigSslConfig(self.request.get("ssl_config", {})).to_request(),
        }

    def _response(self):
        return {
            "requireConnectors": self.response.get("requireConnectors"),
            "sslConfig": ClientConnectionConfigSslConfig().from_response(self.response.get("sslConfig", {})),
        }


class ClientConnectionConfigSslConfig(gcp.Resource):
    def _request(self):
        return {
            "sslMode": self.request.get("ssl_mode"),
        }

    def _response(self):
        return {
            "sslMode": self.response.get("sslMode"),
        }


class MachineConfig(gcp.Resource):
    def _request(self):
        return {
            "cpuCount": self.request.get("cpu_count"),
            "machineType": self.request.get("machine_type"),
        }

    def _response(self):
        return {
            "cpuCount": self.response.get("cpuCount"),
            "machineType": self.response.get("machineType"),
        }


class NetworkConfig(gcp.Resource):
    def _request(self):
        return {
            "authorizedExternalNetworks": [
                NetworkConfigAuthorizedExternalNetwork(item).to_request()
                for item in (self.request.get("authorized_external_networks") or [])
            ],
            "enableOutboundPublicIp": self.request.get("enable_outbound_public_ip"),
            "enablePublicIp": self.request.get("enable_public_ip"),
        }

    def _response(self):
        return {
            "authorizedExternalNetworks": [
                NetworkConfigAuthorizedExternalNetwork().from_response(item)
                for item in (self.response.get("authorizedExternalNetworks") or [])
            ],
            "enableOutboundPublicIp": self.response.get("enableOutboundPublicIp"),
            "enablePublicIp": self.response.get("enablePublicIp"),
        }


class NetworkConfigAuthorizedExternalNetwork(gcp.Resource):
    def _request(self):
        return {
            "cidrRange": self.request.get("cidr_range"),
        }

    def _response(self):
        return {
            "cidrRange": self.response.get("cidrRange"),
        }


class ObservabilityConfig(gcp.Resource):
    def _request(self):
        return {
            "assistiveExperiencesEnabled": self.request.get("assistive_experiences_enabled"),
            "enabled": self.request.get("enabled"),
            "maxQueryStringLength": self.request.get("max_query_string_length"),
            "preserveComments": self.request.get("preserve_comments"),
            "queryPlansPerMinute": self.request.get("query_plans_per_minute"),
            "recordApplicationTags": self.request.get("record_application_tags"),
            "trackActiveQueries": self.request.get("track_active_queries"),
            "trackWaitEventTypes": self.request.get("track_wait_event_types"),
            "trackWaitEvents": self.request.get("track_wait_events"),
        }

    def _response(self):
        return {
            "assistiveExperiencesEnabled": self.response.get("assistiveExperiencesEnabled"),
            "enabled": self.response.get("enabled"),
            "maxQueryStringLength": self.response.get("maxQueryStringLength"),
            "preserveComments": self.response.get("preserveComments"),
            "queryPlansPerMinute": self.response.get("queryPlansPerMinute"),
            "recordApplicationTags": self.response.get("recordApplicationTags"),
            "trackActiveQueries": self.response.get("trackActiveQueries"),
            "trackWaitEventTypes": self.response.get("trackWaitEventTypes"),
            "trackWaitEvents": self.response.get("trackWaitEvents"),
        }


class PscInstanceConfig(gcp.Resource):
    def _request(self):
        return {
            "allowedConsumerProjects": self.request.get("allowed_consumer_projects"),
            "pscAutoConnections": [
                PscInstanceConfigPscAutoConnection(item).to_request()
                for item in (self.request.get("psc_auto_connections") or [])
            ],
            "pscInterfaceConfigs": [
                PscInstanceConfigPscInterfaceConfig(item).to_request()
                for item in (self.request.get("psc_interface_configs") or [])
            ],
        }

    def _response(self):
        return {
            "allowedConsumerProjects": self.response.get("allowedConsumerProjects"),
            "pscAutoConnections": [
                PscInstanceConfigPscAutoConnection().from_response(item)
                for item in (self.response.get("pscAutoConnections") or [])
            ],
            "pscDnsName": self.response.get("pscDnsName"),
            "pscInterfaceConfigs": [
                PscInstanceConfigPscInterfaceConfig().from_response(item)
                for item in (self.response.get("pscInterfaceConfigs") or [])
            ],
            "serviceAttachmentLink": self.response.get("serviceAttachmentLink"),
        }


class PscInstanceConfigPscAutoConnection(gcp.Resource):
    def _request(self):
        return {
            "consumerNetwork": self.request.get("consumer_network"),
            "consumerProject": self.request.get("consumer_project"),
        }

    def _response(self):
        return {
            "consumerNetwork": self.response.get("consumerNetwork"),
            "consumerNetworkStatus": self.response.get("consumerNetworkStatus"),
            "consumerProject": self.response.get("consumerProject"),
            "ipAddress": self.response.get("ipAddress"),
            "status": self.response.get("status"),
        }


class PscInstanceConfigPscInterfaceConfig(gcp.Resource):
    def _request(self):
        return {
            "networkAttachmentResource": self.request.get("network_attachment_resource"),
        }

    def _response(self):
        return {
            "networkAttachmentResource": self.response.get("networkAttachmentResource"),
        }


class QueryInsightsConfig(gcp.Resource):
    def _request(self):
        return {
            "queryPlansPerMinute": self.request.get("query_plans_per_minute"),
            "queryStringLength": self.request.get("query_string_length"),
            "recordApplicationTags": self.request.get("record_application_tags"),
            "recordClientAddress": self.request.get("record_client_address"),
        }

    def _response(self):
        return {
            "queryPlansPerMinute": self.response.get("queryPlansPerMinute"),
            "queryStringLength": self.response.get("queryStringLength"),
            "recordApplicationTags": self.response.get("recordApplicationTags"),
            "recordClientAddress": self.response.get("recordClientAddress"),
        }


class ReadPoolConfig(gcp.Resource):
    def _request(self):
        return {
            "nodeCount": self.request.get("node_count"),
        }

    def _response(self):
        return {
            "nodeCount": self.response.get("nodeCount"),
        }


class Alloydb(gcp.Resource):
    def _request(self):
        return {
            "activationPolicy": self.request.get("activation_policy"),
            "annotations": self.request.get("annotations"),
            "availabilityType": self.request.get("availability_type"),
            "clientConnectionConfig": ClientConnectionConfig(
                self.request.get("client_connection_config", {})
            ).to_request(),
            "databaseFlags": self.request.get("database_flags"),
            "displayName": self.request.get("display_name"),
            "gceZone": self.request.get("gce_zone"),
            "instanceType": self.request.get("instance_type"),
            "labels": self.request.get("labels"),
            "machineConfig": MachineConfig(self.request.get("machine_config", {})).to_request(),
            "networkConfig": NetworkConfig(self.request.get("network_config", {})).to_request(),
            "observabilityConfig": ObservabilityConfig(self.request.get("observability_config", {})).to_request(),
            "pscInstanceConfig": PscInstanceConfig(self.request.get("psc_instance_config", {})).to_request(),
            "queryInsightsConfig": QueryInsightsConfig(self.request.get("query_insights_config", {})).to_request(),
            "readPoolConfig": ReadPoolConfig(self.request.get("read_pool_config", {})).to_request(),
        }

    def _response(self):
        return {
            "activationPolicy": self.response.get("activationPolicy"),
            "annotations": self.response.get("annotations"),
            "availabilityType": self.response.get("availabilityType"),
            "clientConnectionConfig": ClientConnectionConfig().from_response(
                self.response.get("clientConnectionConfig", {})
            ),
            "createTime": self.response.get("createTime"),
            "databaseFlags": self.response.get("databaseFlags"),
            "displayName": self.response.get("displayName"),
            "gceZone": self.response.get("gceZone"),
            "instanceType": self.response.get("instanceType"),
            "ipAddress": self.response.get("ipAddress"),
            "labels": self.response.get("labels"),
            "machineConfig": MachineConfig().from_response(self.response.get("machineConfig", {})),
            "name": self.response.get("name"),
            "networkConfig": NetworkConfig().from_response(self.response.get("networkConfig", {})),
            "observabilityConfig": ObservabilityConfig().from_response(self.response.get("observabilityConfig", {})),
            "outboundPublicIpAddresses": [str(item) for item in (self.response.get("outboundPublicIpAddresses") or [])],
            "pscInstanceConfig": PscInstanceConfig().from_response(self.response.get("pscInstanceConfig", {})),
            "publicIpAddress": self.response.get("publicIpAddress"),
            "queryInsightsConfig": QueryInsightsConfig().from_response(self.response.get("queryInsightsConfig", {})),
            "readPoolConfig": ReadPoolConfig().from_response(self.response.get("readPoolConfig", {})),
            "reconciling": self.response.get("reconciling"),
            "uid": self.response.get("uid"),
            "updateTime": self.response.get("updateTime"),
        }


################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            activation_policy=dict(
                type="str",
                choices=["ACTIVATION_POLICY_UNSPECIFIED", "ALWAYS", "NEVER"],
            ),
            annotations=dict(
                type="dict",
            ),
            availability_type=dict(
                type="str",
                choices=["AVAILABILITY_TYPE_UNSPECIFIED", "ZONAL", "REGIONAL"],
            ),
            client_connection_config=dict(
                type="dict",
                options=dict(
                    require_connectors=dict(
                        type="bool",
                    ),
                    ssl_config=dict(
                        type="dict",
                        options=dict(
                            ssl_mode=dict(
                                type="str",
                                choices=["ENCRYPTED_ONLY", "ALLOW_UNENCRYPTED_AND_ENCRYPTED"],
                            )
                        ),
                    ),
                ),
            ),
            cluster=dict(
                type="dict",
                required=True,
            ),
            database_flags=dict(
                type="dict",
            ),
            display_name=dict(
                type="str",
            ),
            gce_zone=dict(
                type="str",
            ),
            instance_id=dict(
                type="str",
                required=True,
            ),
            instance_type=dict(
                type="str",
                required=True,
                choices=["PRIMARY", "READ_POOL", "SECONDARY"],
            ),
            labels=dict(
                type="dict",
            ),
            machine_config=dict(
                type="dict",
                options=dict(
                    cpu_count=dict(
                        type="int",
                    ),
                    machine_type=dict(
                        type="str",
                    ),
                ),
            ),
            network_config=dict(
                type="dict",
                options=dict(
                    authorized_external_networks=dict(
                        type="list",
                        elements="dict",
                        options=dict(
                            cidr_range=dict(
                                type="str",
                            )
                        ),
                    ),
                    enable_outbound_public_ip=dict(
                        type="bool",
                    ),
                    enable_public_ip=dict(
                        type="bool",
                    ),
                ),
                required_together=[["authorized_external_networks", "enable_public_ip"]],
            ),
            observability_config=dict(
                type="dict",
                options=dict(
                    assistive_experiences_enabled=dict(
                        type="bool",
                    ),
                    enabled=dict(
                        type="bool",
                    ),
                    max_query_string_length=dict(
                        type="int",
                    ),
                    preserve_comments=dict(
                        type="bool",
                    ),
                    query_plans_per_minute=dict(
                        type="int",
                    ),
                    record_application_tags=dict(
                        type="bool",
                    ),
                    track_active_queries=dict(
                        type="bool",
                    ),
                    track_wait_event_types=dict(
                        type="bool",
                    ),
                    track_wait_events=dict(
                        type="bool",
                    ),
                ),
            ),
            psc_instance_config=dict(
                type="dict",
                options=dict(
                    allowed_consumer_projects=dict(
                        type="list",
                        elements="str",
                    ),
                    psc_auto_connections=dict(
                        type="list",
                        elements="dict",
                        options=dict(
                            consumer_network=dict(
                                type="str",
                            ),
                            consumer_network_status=dict(
                                type="str",
                            ),
                            consumer_project=dict(
                                type="str",
                            ),
                            ip_address=dict(
                                type="str",
                            ),
                            status=dict(
                                type="str",
                            ),
                        ),
                    ),
                    psc_dns_name=dict(
                        type="str",
                    ),
                    psc_interface_configs=dict(
                        type="list",
                        elements="dict",
                        options=dict(
                            network_attachment_resource=dict(
                                type="str",
                            )
                        ),
                    ),
                    service_attachment_link=dict(
                        type="str",
                    ),
                ),
            ),
            query_insights_config=dict(
                type="dict",
                options=dict(
                    query_plans_per_minute=dict(
                        type="int",
                    ),
                    query_string_length=dict(
                        type="int",
                    ),
                    record_application_tags=dict(
                        type="bool",
                    ),
                    record_client_address=dict(
                        type="bool",
                    ),
                ),
            ),
            read_pool_config=dict(
                type="dict",
                options=dict(
                    node_count=dict(
                        type="int",
                    )
                ),
            ),
        )
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "create": gcp.ResourceOpConfig(
                **{
                    "uri": "{cluster}/instances?instanceId={instance_id}",
                    "async_uri": "{op_id}",
                    "verb": "POST",
                    "timeout_minutes": 120,
                }
            ),
            "delete": gcp.ResourceOpConfig(
                **{
                    "uri": "{cluster}/instances/{instance_id}",
                    "async_uri": "{op_id}",
                    "verb": "DELETE",
                    "timeout_minutes": 120,
                }
            ),
            "read": gcp.ResourceOpConfig(
                **{"uri": "{cluster}/instances/{instance_id}", "async_uri": "", "verb": "GET", "timeout_minutes": 0}
            ),
            "update": gcp.ResourceOpConfig(
                **{
                    "uri": "{cluster}/instances/{instance_id}",
                    "async_uri": "{op_id}",
                    "verb": "PATCH",
                    "timeout_minutes": 120,
                }
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = Alloydb(params, module=module, product="Alloydb", kind="alloydb#instance")
    existing_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)

    if existing_obj is None:
        if state == "present":
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            # --------- BEGIN custom pre-create code ---------
            # 'templates/terraform/pre_create/alloydb_instance.go.tmpl'
            # --------- END custom pre-create code ---------
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            # --------- BEGIN custom pre-delete code ---------
            # 'templates/terraform/pre_delete/alloydb_instance.go.tmpl'
            # --------- END custom pre-delete code ---------
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            if resource.diff(existing_obj):
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                # --------- BEGIN custom pre-update code ---------
                # --------- END custom pre-update code ---------
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = resource.diff(new_obj)

    new_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
