/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.A98RGBColorProfile;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.DisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.LinearA98RGBColorProfile;
import io.sf.carte.doc.style.css.property.LinearDisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.LinearProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.LinearRec2020ColorProfile;
import io.sf.carte.doc.style.css.property.LinearSRGBColorProfile;
import io.sf.carte.doc.style.css.property.ProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.ProfiledColorImpl;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.Rec2020ColorProfile;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class ColorConverter {
    private final boolean createValue;
    private BaseColor destColor;

    public ColorConverter(boolean createValue) {
        this.createValue = createValue;
    }

    public BaseColor getLastColor() {
        return this.destColor;
    }

    double[] toColorSpace(BaseColor source, String colorSpace, boolean clamp) throws DOMException {
        double[] result;
        colorSpace = colorSpace.toLowerCase(Locale.ROOT);
        String sourceCS = source.getColorSpace();
        if (sourceCS.equals(colorSpace) && (!"srgb".equals(sourceCS) || source.getColorModel() == CSSColorValue.ColorModel.RGB)) {
            if (this.createValue) {
                this.destColor = source;
            }
            return source.toNumberArray();
        }
        switch (colorSpace) {
            case "srgb": {
                result = source.toSRGB(clamp);
                if (!this.createValue) break;
                this.destColor = new RGBColor();
                break;
            }
            case "srgb-linear": {
                LinearSRGBColorProfile profile = new LinearSRGBColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("srgb-linear");
                break;
            }
            case "display-p3": {
                DisplayP3ColorProfile profile = new DisplayP3ColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("display-p3");
                break;
            }
            case "a98-rgb": {
                A98RGBColorProfile profile = new A98RGBColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("a98-rgb");
                break;
            }
            case "prophoto-rgb": {
                ProPhotoRGBColorProfile profile = new ProPhotoRGBColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("prophoto-rgb");
                break;
            }
            case "rec2020": {
                Rec2020ColorProfile profile = new Rec2020ColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("rec2020");
                break;
            }
            case "xyz": 
            case "xyz-d65": {
                result = source.toXYZ(Illuminant.D65);
                if (!this.createValue) break;
                this.destColor = new XYZColorImpl(Illuminant.D65);
                break;
            }
            case "xyz-d50": {
                result = source.toXYZ(Illuminant.D50);
                if (!this.createValue) break;
                this.destColor = new XYZColorImpl(Illuminant.D50);
                break;
            }
            case "hsl": 
            case "hsla": {
                if (source.getColorModel() == CSSColorValue.ColorModel.HSL) {
                    result = source.toNumberArray();
                } else {
                    result = source.toSRGB(true);
                    result = ColorUtil.srgbToHsl(result[0], result[1], result[2]);
                }
                if (!this.createValue) break;
                this.destColor = new HSLColorImpl();
                break;
            }
            case "hwb": {
                if (source.getColorModel() == CSSColorValue.ColorModel.HWB) {
                    result = source.toNumberArray();
                } else {
                    double[] rgb = source.toSRGB(true);
                    result = ColorUtil.srgbToHwb(rgb);
                }
                if (!this.createValue) break;
                this.destColor = new HWBColorImpl();
                break;
            }
            case "lab": {
                result = new double[3];
                if (source.getSpace() == BaseColor.Space.CIE_LCh) {
                    double[] lch = source.toNumberArray();
                    ColorUtil.lchToLab(lch, result);
                } else {
                    double[] xyz = source.toXYZ(Illuminant.D50);
                    ColorUtil.xyzD50ToLab(xyz, result);
                }
                if (!this.createValue) break;
                this.destColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                break;
            }
            case "lch": {
                double[] lab;
                if (source.getSpace() == BaseColor.Space.CIE_Lab) {
                    lab = source.toNumberArray();
                } else {
                    double[] xyz = source.toXYZ(Illuminant.D50);
                    lab = new double[3];
                    ColorUtil.xyzD50ToLab(xyz, lab);
                }
                result = new double[3];
                ColorUtil.labToLCh(lab, result);
                if (!this.createValue) break;
                this.destColor = new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch");
                break;
            }
            case "oklab": {
                result = new double[3];
                if (source.getSpace() == BaseColor.Space.OK_LCh) {
                    double[] lch = source.toNumberArray();
                    ColorUtil.lchToLab(lch, result);
                } else {
                    double[] xyz = source.toXYZ(Illuminant.D65);
                    ColorUtil.xyzD65ToOkLab(xyz, result);
                }
                if (!this.createValue) break;
                this.destColor = new LABColorImpl(BaseColor.Space.OK_Lab, "oklab");
                break;
            }
            case "oklch": {
                double[] oklab;
                if (source.getSpace() == BaseColor.Space.OK_Lab) {
                    oklab = source.toNumberArray();
                } else {
                    double[] xyz = source.toXYZ(Illuminant.D65);
                    oklab = new double[3];
                    ColorUtil.xyzD65ToOkLab(xyz, oklab);
                }
                result = new double[3];
                ColorUtil.labToLCh(oklab, result);
                if (!this.createValue) break;
                this.destColor = new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch");
                break;
            }
            case "--display-p3-linear": {
                LinearDisplayP3ColorProfile profile = new LinearDisplayP3ColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--display-p3-linear", profile, result);
                break;
            }
            case "--a98-rgb-linear": {
                LinearA98RGBColorProfile profile = new LinearA98RGBColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--a98-rgb-linear", profile, result);
                break;
            }
            case "--rec2020-linear": {
                LinearRec2020ColorProfile profile = new LinearRec2020ColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--rec2020-linear", profile, result);
                break;
            }
            case "--prophoto-rgb-linear": {
                LinearProPhotoRGBColorProfile profile = new LinearProPhotoRGBColorProfile();
                result = new double[3];
                this.convertToProfiled(profile, source, clamp, result);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--prophoto-rgb-linear", profile, result);
                break;
            }
            default: {
                throw new DOMNotSupportedException("Unsupported color space: " + colorSpace);
            }
        }
        if (this.createValue) {
            this.destColor.setAlpha(source.getAlpha().clone());
            this.destColor.setColorComponents(result);
        }
        return result;
    }

    private void convertToProfiled(ColorProfile profile, BaseColor source, boolean clamp, double[] rgb) {
        double[] xyz = source.toXYZ(profile.getIlluminant());
        profile.xyzToLinearRgb(xyz, rgb);
        rgb[0] = profile.gammaCompanding(rgb[0]);
        rgb[1] = profile.gammaCompanding(rgb[1]);
        rgb[2] = profile.gammaCompanding(rgb[2]);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            double[] lab = new double[3];
            if (profile.getIlluminant() == Illuminant.D65) {
                xyz = ColorUtil.d65xyzToD50(xyz);
            }
            ColorUtil.xyzD50ToLab(xyz, lab);
            ColorUtil.labToClampedRGB(lab[0], lab[1], lab[2], true, profile, rgb);
        }
    }
}

