/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

final class WrapperPrintStream
extends PrintStream {
    private String m_header;

    WrapperPrintStream(PrintStream parent, String header) {
        super(parent);
        this.m_header = header;
    }

    WrapperPrintStream(PrintStream parent, boolean autoFlush, String encoding, String header) throws UnsupportedEncodingException {
        super((OutputStream)parent, autoFlush, encoding);
        this.m_header = header;
    }

    @Override
    public void println() {
        super.println(this.m_header);
    }

    @Override
    public void println(String x) {
        if (x.indexOf("\n") >= 0) {
            String[] lines = x.split("[\n]", -1);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(this.m_header);
                sb.append(lines[i]);
            }
            super.println(sb.toString());
        } else {
            super.println(this.m_header + x);
        }
    }

    @Override
    public void println(Object x) {
        if (x == null) {
            this.println("null");
        } else {
            this.println(x.toString());
        }
    }
}

