/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusTCPTransaction;
import net.wimpi.modbus.msg.ReadInputRegistersRequest;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.procimg.SimpleRegister;

public class AIAOTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InetAddress addr = null;
        TCPMasterConnection con = null;
        ReadInputRegistersRequest ai_req = null;
        WriteSingleRegisterRequest ao_req = null;
        ModbusTCPTransaction ai_trans = null;
        ModbusTCPTransaction ao_trans = null;
        int ai_ref = 0;
        int ao_ref = 0;
        int port = 502;
        try {
            try {
                if (args.length < 3) {
                    AIAOTest.printUsage();
                    System.exit(1);
                } else {
                    try {
                        String astr = args[0];
                        int idx = astr.indexOf(58);
                        if (idx > 0) {
                            port = Integer.parseInt(astr.substring(idx + 1));
                            astr = astr.substring(0, idx);
                        }
                        addr = InetAddress.getByName(astr);
                        ai_ref = Integer.parseInt(args[1]);
                        ao_ref = Integer.parseInt(args[2]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        AIAOTest.printUsage();
                        System.exit(1);
                    }
                }
                con = new TCPMasterConnection(addr);
                con.setPort(port);
                con.connect();
                if (Modbus.debug) {
                    System.out.println("Connected to " + addr.toString() + ":" + con.getPort());
                }
                ai_req = new ReadInputRegistersRequest(ai_ref, 1);
                ao_req = new WriteSingleRegisterRequest();
                ao_req.setReference(ao_ref);
                ai_req.setUnitID(0);
                ao_req.setUnitID(0);
                ai_trans = new ModbusTCPTransaction(con);
                ai_trans.setRequest(ai_req);
                ao_trans = new ModbusTCPTransaction(con);
                ao_trans.setRequest(ao_req);
                SimpleRegister new_out = new SimpleRegister(0);
                ao_req.setRegister(new_out);
                int last_out = Integer.MIN_VALUE;
                while (true) {
                    ai_trans.execute();
                    int new_in = ((ReadInputRegistersResponse)ai_trans.getResponse()).getRegister(0).getValue();
                    if (new_in == last_out) continue;
                    new_out.setValue(new_in);
                    ao_trans.execute();
                    last_out = new_in;
                    if (!Modbus.debug) continue;
                    System.out.println("Updated Register with value from Input Register.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                con.close();
            }
        }
        catch (Throwable throwable) {
            con.close();
            throw throwable;
        }
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.AIAOTest <address{:<port>} [String]> <register a_in [int16]> <register a_out [int16]>");
    }
}

