/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PipedAudioStream
extends AudioStream {
    private final AudioFormat format;
    private final PipedInputStream pipedInput;
    private final PipedOutputStream pipedOutput;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final LinkedList<Runnable> onCloseChain = new LinkedList();

    protected PipedAudioStream(AudioFormat format, int pipeSize, PipedOutputStream outputStream) throws IOException {
        this.pipedOutput = outputStream;
        this.pipedInput = new PipedInputStream(outputStream, pipeSize);
        this.format = format;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int read() throws IOException {
        if (this.closed.get()) {
            return -1;
        }
        return this.pipedInput.read();
    }

    @Override
    public int read(byte @Nullable [] b) throws IOException {
        if (this.closed.get()) {
            return -1;
        }
        return this.pipedInput.read(b);
    }

    @Override
    public int read(byte @Nullable [] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            return -1;
        }
        return this.pipedInput.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (!this.onCloseChain.isEmpty()) {
            this.onCloseChain.forEach(Runnable::run);
            this.onCloseChain.clear();
        }
        this.pipedOutput.close();
        this.pipedInput.close();
    }

    public void onClose(Runnable onClose) {
        this.onCloseChain.add(onClose);
    }

    protected PipedOutputStream getOutputStream() {
        return this.pipedOutput;
    }

    public static Group newGroup(AudioFormat format) {
        int pipeSize = Math.round((float)Objects.requireNonNull(format.getFrequency()).longValue() * (float)Objects.requireNonNull(format.getBitDepth()).intValue() * (float)Objects.requireNonNull(format.getChannels()).intValue() / 2.0f);
        return new Group(format, pipeSize);
    }

    public static Group newGroup(AudioFormat format, int pipeSize) {
        return new Group(format, pipeSize);
    }

    public static class Group
    extends OutputStream {
        private final int pipeSize;
        private final AudioFormat format;
        private final ConcurrentLinkedQueue<PipedAudioStream> openPipes = new ConcurrentLinkedQueue();
        private final Logger logger = LoggerFactory.getLogger(Group.class);

        protected Group(AudioFormat format, int pipeSize) {
            this.pipeSize = pipeSize;
            this.format = format;
        }

        public PipedAudioStream getAudioStreamInGroup() throws IOException {
            PipedOutputStream pipedOutput = new PipedOutputStream();
            PipedAudioStream audioStream = new PipedAudioStream(this.format, this.pipeSize, pipedOutput);
            if (!this.openPipes.add(audioStream)) {
                audioStream.close();
                throw new IOException("Unable to add new piped stream to group");
            }
            audioStream.onClose(() -> {
                if (!this.openPipes.remove(audioStream)) {
                    this.logger.warn("Trying to remove an unregistered stream, this is not expected");
                }
            });
            return audioStream;
        }

        public boolean isEmpty() {
            return this.openPipes.isEmpty();
        }

        public int size() {
            return this.openPipes.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte @Nullable [] b, int off, int len) {
            ConcurrentLinkedQueue<PipedAudioStream> concurrentLinkedQueue = this.openPipes;
            synchronized (concurrentLinkedQueue) {
                for (PipedAudioStream pipe : this.openPipes) {
                    try {
                        pipe.getOutputStream().write(b, off, len);
                    }
                    catch (InterruptedIOException e) {
                        this.logger.warn("InterruptedIOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("RuntimeException while writing to pipe: {}", (Object)e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            ConcurrentLinkedQueue<PipedAudioStream> concurrentLinkedQueue = this.openPipes;
            synchronized (concurrentLinkedQueue) {
                for (PipedAudioStream pipe : this.openPipes) {
                    try {
                        pipe.getOutputStream().write(b);
                    }
                    catch (InterruptedIOException e) {
                        this.logger.warn("InterruptedIOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("RuntimeException while writing to pipe: {}", (Object)e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte @Nullable [] bytes) {
            ConcurrentLinkedQueue<PipedAudioStream> concurrentLinkedQueue = this.openPipes;
            synchronized (concurrentLinkedQueue) {
                for (PipedAudioStream pipe : this.openPipes) {
                    try {
                        pipe.getOutputStream().write(bytes);
                    }
                    catch (InterruptedIOException e) {
                        this.logger.warn("InterruptedIOException on pipe flush: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException on pipe flush: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("RuntimeException on pipe flush: {}", (Object)e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            ConcurrentLinkedQueue<PipedAudioStream> concurrentLinkedQueue = this.openPipes;
            synchronized (concurrentLinkedQueue) {
                for (PipedAudioStream pipe : this.openPipes) {
                    try {
                        pipe.getOutputStream().flush();
                    }
                    catch (InterruptedIOException e) {
                        this.logger.warn("InterruptedIOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException while writing to pipe: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("RuntimeException while writing to pipe: {}", (Object)e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ConcurrentLinkedQueue<PipedAudioStream> concurrentLinkedQueue = this.openPipes;
            synchronized (concurrentLinkedQueue) {
                for (PipedAudioStream pipe : this.openPipes) {
                    try {
                        pipe.close();
                    }
                    catch (InterruptedIOException e) {
                        this.logger.warn("InterruptedIOException closing pipe: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException closing pipe: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("RuntimeException closing pipe: {}", (Object)e.getMessage());
                    }
                }
                this.openPipes.clear();
            }
        }
    }
}

