/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.pool;

import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.pool.ObjectPool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ThreadLocalObjectPool<O>
implements ObjectPool<O> {
    private final ThreadLocal<O> tl;
    private final ObjectPool.ObjectSanitizer<O> sanitizer;
    private final ObjectPool.Lease<O> leaseImpl = new ObjectPool.Lease<O>(){
        private boolean discarded = false;

        @Override
        public void close() {
            if (!this.discarded && !ThreadLocalObjectPool.this.sanitizer.sanitize(ThreadLocalObjectPool.this.tl.get())) {
                ThreadLocalObjectPool.this.tl.remove();
            }
        }

        @Override
        public O get() {
            return ThreadLocalObjectPool.this.tl.get();
        }

        @Override
        public void discard() {
            this.discarded = true;
            ThreadLocalObjectPool.this.tl.remove();
        }
    };

    ThreadLocalObjectPool(final ObjectPool.ObjectSupplier<@NonNull O> supplier, ObjectPool.ObjectSanitizer<@NonNull O> sanitizer) {
        this.sanitizer = sanitizer;
        this.tl = new ThreadLocal<O>(this){
            final /* synthetic */ ThreadLocalObjectPool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected O initialValue() {
                return supplier.get();
            }
        };
    }

    @Override
    public ObjectPool.Lease<O> take() {
        return this.leaseImpl;
    }
}

