/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpput;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpput.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFTPPUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String serverName;
    private String serverPort;
    private String userName;
    private String password;
    private String remoteDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyPuttingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private static String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";

    public JobEntryFTPPUT(String n) {
        super(n, "");
        this.serverName = null;
        this.serverPort = "21";
        this.remoteDirectory = null;
        this.localDirectory = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.FTP_PUT);
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public JobEntryFTPPUT() {
        this("");
    }

    public JobEntryFTPPUT(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryFTPPUT je = (JobEntryFTPPUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remoteDirectory", (String)this.remoteDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localDirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyPuttingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.remoteDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"remoteDirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localDirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyPuttingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.controlEncoding = XMLHandler.getTagValue((Node)entrynode, (String)"control_encoding");
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobFTPPUT.Log.UnableToLoadFromXml"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            int intServerPort = (int)rep.getJobEntryAttributeInteger(id_jobentry, "serverport");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            if (intServerPort > 0 && Const.isEmpty((String)this.serverPort)) {
                this.serverPort = Integer.toString(intServerPort);
            }
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.remoteDirectory = rep.getJobEntryAttributeString(id_jobentry, "remoteDirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localDirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyPuttingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.controlEncoding = rep.getJobEntryAttributeString(id_jobentry, "control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobFTPPUT.UnableToLoadFromRepo", String.valueOf(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "remoteDirectory", this.remoteDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "localDirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getID(), "only_new", this.onlyPuttingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getID(), "control_encoding", this.controlEncoding);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobFTPPUT.UnableToSaveToRepo", String.valueOf(id_job)), (Throwable)dbe);
        }
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isOnlyPuttingNewFiles() {
        return this.onlyPuttingNewFiles;
    }

    public void setOnlyPuttingNewFiles(boolean onlyPuttingNewFiles) {
        this.onlyPuttingNewFiles = onlyPuttingNewFiles;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String encoding) {
        this.controlEncoding = encoding;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String directory) {
        this.localDirectory = directory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block42: {
            LogWriter log = LogWriter.getInstance();
            result = previousResult;
            result.setResult(false);
            long filesput = 0L;
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.Starting"), new Object[0]);
            }
            String realServerName = this.environmentSubstitute(this.serverName);
            String realServerPort = this.environmentSubstitute(this.serverPort);
            String realUsername = this.environmentSubstitute(this.userName);
            String realPassword = this.environmentSubstitute(this.password);
            String realRemoteDirectory = this.environmentSubstitute(this.remoteDirectory);
            String realWildcard = this.environmentSubstitute(this.wildcard);
            String realLocalDirectory = this.environmentSubstitute(this.localDirectory);
            FTPClient ftpclient = null;
            try {
                block41: {
                    ftpclient = new FTPClient();
                    ftpclient.setRemoteAddr(InetAddress.getByName(realServerName));
                    if (!Const.isEmpty((String)realServerPort)) {
                        ftpclient.setRemotePort(Const.toInt((String)realServerPort, (int)21));
                    }
                    if (!Const.isEmpty((String)this.proxyHost)) {
                        int port;
                        String realProxy_host = this.environmentSubstitute(this.proxyHost);
                        ftpclient.setRemoteAddr(InetAddress.getByName(realProxy_host));
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFTPPUT.OpenedProxyConnectionOn", realProxy_host), new Object[0]);
                        }
                        if ((port = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                            ftpclient.setRemotePort(port);
                        }
                    } else {
                        ftpclient.setRemoteAddr(InetAddress.getByName(realServerName));
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryFTPPUT.OpenConnection", realServerName), new Object[0]);
                        }
                    }
                    if (this.activeConnection) {
                        ftpclient.setConnectMode(FTPConnectMode.ACTIVE);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.SetActiveConnection"), new Object[0]);
                        }
                    } else {
                        ftpclient.setConnectMode(FTPConnectMode.PASV);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.SetPassiveConnection"), new Object[0]);
                        }
                    }
                    if (this.timeout > 0) {
                        ftpclient.setTimeout(this.timeout);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.SetTimeout", "" + this.timeout), new Object[0]);
                        }
                    }
                    ftpclient.setControlEncoding(this.controlEncoding);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.SetEncoding", this.controlEncoding), new Object[0]);
                    }
                    ftpclient.connect();
                    ftpclient.login(realUsername, realPassword);
                    if (this.binaryMode) {
                        ftpclient.setType(FTPTransferType.BINARY);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.BinaryMode"), new Object[0]);
                        }
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.Logged", realUsername), new Object[0]);
                    }
                    if (!Const.isEmpty((String)realRemoteDirectory)) {
                        ftpclient.chdir(realRemoteDirectory);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.ChangedDirectory", realRemoteDirectory), new Object[0]);
                        }
                    }
                    int x = 0;
                    ArrayList<String> myFileList = new ArrayList<String>();
                    File localFiles = new File(realLocalDirectory);
                    File[] children = localFiles.listFiles();
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i].isDirectory()) continue;
                        myFileList.add(children[i].getName());
                        ++x;
                    }
                    String[] filelist = new String[myFileList.size()];
                    myFileList.toArray(filelist);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.FoundFileLocalDirectory", "" + filelist.length, realLocalDirectory), new Object[0]);
                    }
                    Pattern pattern = null;
                    if (!Const.isEmpty((String)realWildcard)) {
                        pattern = Pattern.compile(realWildcard);
                    }
                    for (int i = 0; i < filelist.length && !parentJob.isStopped(); ++i) {
                        boolean getIt = true;
                        if (pattern != null) {
                            Matcher matcher = pattern.matcher(filelist[i]);
                            getIt = matcher.matches();
                        }
                        if (!getIt) continue;
                        boolean fileExist = false;
                        try {
                            fileExist = ftpclient.exists(filelist[i]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (log.isDebug()) {
                            if (fileExist) {
                                log.logDebug(this.toString(), Messages.getString("JobFTPPUT.Log.FileExists", filelist[i]), new Object[0]);
                            } else {
                                log.logDebug(this.toString(), Messages.getString("JobFTPPUT.Log.FileDoesNotExists", filelist[i]), new Object[0]);
                            }
                        }
                        if (fileExist && (this.onlyPuttingNewFiles || !fileExist)) continue;
                        if (log.isDebug()) {
                            log.logDebug(this.toString(), Messages.getString("JobFTPPUT.Log.PuttingFileToRemoteDirectory", filelist[i], realRemoteDirectory), new Object[0]);
                        }
                        String localFilename = realLocalDirectory + Const.FILE_SEPARATOR + filelist[i];
                        ftpclient.put(localFilename, filelist[i]);
                        ++filesput;
                        if (!this.remove) continue;
                        new File(localFilename).delete();
                        if (!log.isDetailed()) continue;
                        log.logDetailed(this.toString(), Messages.getString("JobFTPPUT.Log.DeletedFile", localFilename), new Object[0]);
                    }
                    result.setResult(true);
                    if (!log.isDetailed()) break block41;
                    log.logDebug(this.toString(), Messages.getString("JobFTPPUT.Log.WeHavePut", "" + filesput), new Object[0]);
                }
                Object var28_32 = null;
            }
            catch (Throwable throwable) {
                Object var28_34 = null;
                if (ftpclient != null && ftpclient.connected()) {
                    try {
                        ftpclient.quit();
                    }
                    catch (Exception e2) {
                        log.logError(this.toString(), Messages.getString("JobFTPPUT.Log.ErrorQuitingFTP", e2.getMessage()), new Object[0]);
                    }
                }
                throw throwable;
            }
            if (ftpclient != null && ftpclient.connected()) {
                try {
                    ftpclient.quit();
                }
                catch (Exception e2) {
                    log.logError(this.toString(), Messages.getString("JobFTPPUT.Log.ErrorQuitingFTP", e2.getMessage()), new Object[0]);
                }
            }
            break block42;
            {
                catch (Exception e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobFTPPUT.Log.ErrorPuttingFiles", e.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    Object var28_33 = null;
                    if (ftpclient != null && ftpclient.connected()) {
                        try {
                            ftpclient.quit();
                        }
                        catch (Exception e2) {
                            log.logError(this.toString(), Messages.getString("JobFTPPUT.Log.ErrorQuitingFTP", e2.getMessage()), new Object[0]);
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

