/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.kademlia.KBucket;
import net.i2p.kademlia.KBucketTrimmer;
import org.klomp.snark.dht.NID;

class KBTrimmer
implements KBucketTrimmer<NID> {
    private final I2PAppContext _ctx;
    private final int _max;
    private static final long MIN_BUCKET_AGE = 300000L;
    private static final long MAX_NODE_AGE = 900000L;

    public KBTrimmer(I2PAppContext ctx, int max) {
        this._ctx = ctx;
        this._max = max;
    }

    @Override
    public boolean trim(KBucket<NID> kbucket, NID toAdd) {
        long now = this._ctx.clock().now();
        if (kbucket.getLastChanged() > now - 300000L) {
            return false;
        }
        Set<NID> entries = kbucket.getEntries();
        for (NID nid : entries) {
            if (nid.lastSeen() >= now - 900000L || !kbucket.remove(nid)) continue;
            return true;
        }
        return entries.size() < this._max;
    }
}

