/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.ClassFileBuilder;
import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.ClassFileTransform;
import io.github.dmlloyd.classfile.ClassTransform;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.FieldTransform;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodElement;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.MethodTransform;
import io.github.dmlloyd.classfile.impl.ChainedClassBuilder;
import io.github.dmlloyd.classfile.impl.ChainedCodeBuilder;
import io.github.dmlloyd.classfile.impl.ChainedFieldBuilder;
import io.github.dmlloyd.classfile.impl.ChainedMethodBuilder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class TransformImpl {
    private static final Runnable NOTHING = () -> {};

    private TransformImpl() {
    }

    private static Runnable chainRunnable(Runnable a, Runnable b) {
        return () -> {
            a.run();
            b.run();
        };
    }

    public static <E extends ClassFileElement, B extends ClassFileBuilder<E, B>> ResolvedTransform<E> resolve(ClassFileTransform<?, E, B> transform, B builder) {
        if (transform instanceof ResolvableTransform) {
            ResolvableTransform ut = (ResolvableTransform)((Object)transform);
            return ut.resolve(builder);
        }
        return new ResolvedTransform<ClassFileElement>(e -> transform.accept(builder, e), () -> transform.atEnd(builder), () -> transform.atStart(builder));
    }

    static interface ResolvableTransform<E extends ClassFileElement, B extends ClassFileBuilder<E, B>> {
        public ResolvedTransform<E> resolve(B var1);
    }

    public record ResolvedTransform<E extends ClassFileElement>(Consumer<E> consumer, Runnable endHandler, Runnable startHandler) {
        public ResolvedTransform(Consumer<E> consumer) {
            this(consumer, NOTHING, NOTHING);
        }
    }

    public record SupplierCodeTransform(Supplier<CodeTransform> supplier) implements UnresolvedCodeTransform
    {
        @Override
        public ResolvedTransform<CodeElement> resolve(CodeBuilder builder) {
            return TransformImpl.resolve(this.supplier.get(), builder);
        }
    }

    public record ChainedCodeTransform(CodeTransform t, CodeTransform next) implements UnresolvedCodeTransform
    {
        @Override
        public ResolvedTransform<CodeElement> resolve(CodeBuilder builder) {
            ResolvedTransform<CodeElement> downstream = TransformImpl.resolve(this.next, builder);
            ChainedCodeBuilder chainedBuilder = new ChainedCodeBuilder(builder, downstream.consumer());
            ResolvedTransform<CodeElement> upstream = TransformImpl.resolve(this.t, chainedBuilder);
            return new ResolvedTransform<CodeElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(downstream.startHandler(), upstream.startHandler()));
        }
    }

    static interface UnresolvedCodeTransform
    extends CodeTransform,
    ResolvableTransform<CodeElement, CodeBuilder> {
        @Override
        default public void accept(CodeBuilder builder, CodeElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(CodeBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(CodeBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record SupplierFieldTransform(Supplier<FieldTransform> supplier) implements UnresolvedFieldTransform
    {
        @Override
        public ResolvedTransform<FieldElement> resolve(FieldBuilder builder) {
            return TransformImpl.resolve(this.supplier.get(), builder);
        }
    }

    public record ChainedFieldTransform(FieldTransform t, FieldTransform next) implements UnresolvedFieldTransform
    {
        @Override
        public ResolvedTransform<FieldElement> resolve(FieldBuilder builder) {
            ResolvedTransform<FieldElement> downstream = TransformImpl.resolve(this.next, builder);
            ChainedFieldBuilder chainedBuilder = new ChainedFieldBuilder(builder, downstream.consumer());
            ResolvedTransform<FieldElement> upstream = TransformImpl.resolve(this.t, chainedBuilder);
            return new ResolvedTransform<FieldElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(downstream.startHandler(), upstream.startHandler()));
        }
    }

    static interface UnresolvedFieldTransform
    extends FieldTransform,
    ResolvableTransform<FieldElement, FieldBuilder> {
        @Override
        default public void accept(FieldBuilder builder, FieldElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(FieldBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(FieldBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record MethodCodeTransform(CodeTransform xform) implements UnresolvedMethodTransform
    {
        @Override
        public ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            return new ResolvedTransform<MethodElement>(me -> {
                if (me instanceof CodeModel) {
                    CodeModel cm = (CodeModel)me;
                    builder.transformCode(cm, this.xform);
                } else {
                    builder.with(me);
                }
            }, NOTHING, NOTHING);
        }

        @Override
        public MethodTransform andThen(MethodTransform next) {
            MethodTransform methodTransform;
            if (next instanceof MethodCodeTransform) {
                MethodCodeTransform mct = (MethodCodeTransform)next;
                methodTransform = new MethodCodeTransform(this.xform.andThen(mct.xform));
            } else {
                methodTransform = UnresolvedMethodTransform.super.andThen(next);
            }
            return methodTransform;
        }
    }

    public record SupplierMethodTransform(Supplier<MethodTransform> supplier) implements UnresolvedMethodTransform
    {
        @Override
        public ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            return TransformImpl.resolve(this.supplier.get(), builder);
        }
    }

    public record ChainedMethodTransform(MethodTransform t, MethodTransform next) implements UnresolvedMethodTransform
    {
        @Override
        public ResolvedTransform<MethodElement> resolve(MethodBuilder builder) {
            ResolvedTransform<MethodElement> downstream = TransformImpl.resolve(this.next, builder);
            ChainedMethodBuilder chainedBuilder = new ChainedMethodBuilder(builder, downstream.consumer());
            ResolvedTransform<MethodElement> upstream = TransformImpl.resolve(this.t, chainedBuilder);
            return new ResolvedTransform<MethodElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(downstream.startHandler(), upstream.startHandler()));
        }
    }

    static interface UnresolvedMethodTransform
    extends MethodTransform,
    ResolvableTransform<MethodElement, MethodBuilder> {
        @Override
        default public void accept(MethodBuilder builder, MethodElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(MethodBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(MethodBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }

    public record ClassFieldTransform(FieldTransform transform, Predicate<FieldModel> filter) implements UnresolvedClassTransform
    {
        @Override
        public ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return new ResolvedTransform<ClassElement>(ce -> {
                FieldModel fm;
                if (ce instanceof FieldModel && this.filter.test(fm = (FieldModel)ce)) {
                    builder.transformField(fm, this.transform);
                } else {
                    builder.with(ce);
                }
            });
        }

        @Override
        public ClassTransform andThen(ClassTransform next) {
            if (next instanceof ClassFieldTransform) {
                ClassFieldTransform cft = (ClassFieldTransform)next;
                return new ClassFieldTransform(this.transform.andThen(cft.transform), mm -> this.filter.test((FieldModel)mm) && cft.filter.test((FieldModel)mm));
            }
            return UnresolvedClassTransform.super.andThen(next);
        }
    }

    public record ClassMethodTransform(MethodTransform transform, Predicate<MethodModel> filter) implements UnresolvedClassTransform
    {
        @Override
        public ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return new ResolvedTransform<ClassElement>(ce -> {
                MethodModel mm;
                if (ce instanceof MethodModel && this.filter.test(mm = (MethodModel)ce)) {
                    builder.transformMethod(mm, this.transform);
                } else {
                    builder.with(ce);
                }
            });
        }

        @Override
        public ClassTransform andThen(ClassTransform next) {
            if (next instanceof ClassMethodTransform) {
                ClassMethodTransform cmt = (ClassMethodTransform)next;
                return new ClassMethodTransform(this.transform.andThen(cmt.transform), mm -> this.filter.test((MethodModel)mm) && cmt.filter.test((MethodModel)mm));
            }
            return UnresolvedClassTransform.super.andThen(next);
        }
    }

    public record SupplierClassTransform(Supplier<ClassTransform> supplier) implements UnresolvedClassTransform
    {
        @Override
        public ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            return TransformImpl.resolve(this.supplier.get(), builder);
        }
    }

    public record ChainedClassTransform(ClassTransform t, ClassTransform next) implements UnresolvedClassTransform
    {
        @Override
        public ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
            ResolvedTransform<ClassElement> downstream = TransformImpl.resolve(this.next, builder);
            ChainedClassBuilder chainedBuilder = new ChainedClassBuilder(builder, downstream.consumer());
            ResolvedTransform<ClassElement> upstream = TransformImpl.resolve(this.t, chainedBuilder);
            return new ResolvedTransform<ClassElement>(upstream.consumer(), TransformImpl.chainRunnable(upstream.endHandler(), downstream.endHandler()), TransformImpl.chainRunnable(downstream.startHandler(), upstream.startHandler()));
        }
    }

    static interface UnresolvedClassTransform
    extends ClassTransform,
    ResolvableTransform<ClassElement, ClassBuilder> {
        @Override
        default public void accept(ClassBuilder builder, ClassElement element) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atEnd(ClassBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }

        @Override
        default public void atStart(ClassBuilder builder) {
            throw new UnsupportedOperationException("transforms must be resolved before running");
        }
    }
}

