/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.extension;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.model.script.engine.Script;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.openhab.core.model.script.engine.ScriptParsingException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(service={ConsoleCommandExtension.class})
public class ScriptEngineConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private @Nullable ScriptEngine scriptEngine;

    public ScriptEngineConsoleCommandExtension() {
        super("script", "Execute scripts");
    }

    public void execute(String[] args, Console console) {
        block6: {
            ScriptEngine scriptEngine = this.scriptEngine;
            if (scriptEngine != null) {
                String scriptString = String.join((CharSequence)" ", args);
                try {
                    Script script = scriptEngine.newScriptFromString(scriptString);
                    Object result = script.execute();
                    if (result != null) {
                        console.println(result.toString());
                        break block6;
                    }
                    console.println("OK");
                }
                catch (ScriptParsingException e) {
                    console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while parsing the script"));
                }
                catch (ScriptExecutionException e) {
                    console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while executing the script"));
                }
            } else {
                console.println("Script engine is not available.");
            }
        }
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("<script to execute>", "Executes a script"));
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }
}

