/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.exception;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.exception.ModbusTransportException;

@NonNullByDefault
public class ModbusUnexpectedResponseSizeException
extends ModbusTransportException {
    private static final long serialVersionUID = 2460907938819984483L;
    private int requestSize;
    private int responseSize;

    public ModbusUnexpectedResponseSizeException(int requestSize, int responseSize) {
        this.requestSize = requestSize;
        this.responseSize = responseSize;
    }

    @Override
    public @Nullable String getMessage() {
        return String.format("Data length of the request (%d) does not equal response (%d). Slave response is invalid.", this.requestSize, this.responseSize);
    }

    @Override
    public String toString() {
        return String.format("ModbusUnexpectedResponseSizeException(requestFunctionCode=%d, responseFunctionCode=%d)", this.requestSize, this.responseSize);
    }
}

