/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.environment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.charts.ChartFactory;
import org.graalvm.visualvm.charts.SimpleXYChartDescriptor;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.TimeRecord;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.environment.JFRSnapshotEnvironmentViewProvider;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;

final class EnvironmentViewSupport {
    EnvironmentViewSupport() {
    }

    static class ProcessesSupport
    extends JPanel
    implements JFREventVisitor {
        private Map<Long, String> data;
        private HTMLTextArea area;

        ProcessesSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("System processes", null, 50, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.data = new TreeMap<Long, String>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.SystemProcess".equals(typeName)) {
                try {
                    this.data.put(Long.parseLong(event.getString("pid")), event.getString("commandLine"));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            final StringBuilder s = new StringBuilder();
            if (this.data.isEmpty()) {
                s.append("&lt;unknown&gt;");
            } else {
                s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                s.append("<tr><th align='right' style='margin-bottom:5px;'>PID&nbsp;&nbsp;&nbsp;</th><th align='left' style='margin-bottom:5px;'>Command Line</th></tr>");
                for (Map.Entry<Long, String> entry : this.data.entrySet()) {
                    s.append("<tr><td align='right'>");
                    s.append("<b>" + entry.getKey() + "</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>" + entry.getValue());
                    s.append("</td></tr>");
                }
                s.append("</table>");
            }
            this.data.clear();
            this.data = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(s.toString());
                    area.setCaretPosition(0);
                }
            });
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class EnvVarSupport
    extends JPanel
    implements JFREventVisitor {
        private Map<String, String> data;
        private HTMLTextArea area;

        EnvVarSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Environment variables", null, 40, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.data = new TreeMap<String, String>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.InitialEnvironmentVariable".equals(typeName)) {
                try {
                    this.data.put(event.getString("key"), event.getString("value"));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            final StringBuilder s = new StringBuilder();
            Iterator<Map.Entry<String, String>> it = this.data.entrySet().iterator();
            if (!it.hasNext()) {
                s.append("&lt;unknown&gt;");
            } else {
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    s.append("<nobr><b>" + entry.getKey() + "</b>=" + entry.getValue() + "</nobr>");
                    if (!it.hasNext()) continue;
                    s.append("<br>");
                }
            }
            this.data.clear();
            this.data = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(s.toString());
                    area.setCaretPosition(0);
                }
            });
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class NetworkDetailsSupport
    extends JPanel
    implements JFREventVisitor {
        private Set<String> data;
        private HTMLTextArea area;

        NetworkDetailsSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Network details", null, 30, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.data = new TreeSet<String>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.NetworkUtilization".equals(typeName)) {
                try {
                    this.data.add(event.getString("networkInterface"));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            final StringBuilder s = new StringBuilder();
            Iterator<String> it = this.data.iterator();
            if (!it.hasNext()) {
                s.append("&lt;unknown&gt;");
            } else {
                s.append("<nobr><b>Network interfaces:</b></nobr><br>");
                while (it.hasNext()) {
                    s.append(it.next());
                    if (!it.hasNext()) continue;
                    s.append("<br>");
                }
            }
            this.data.clear();
            this.data = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(s.toString());
                    area.setCaretPosition(0);
                }
            });
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class OSDetailsSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        OSDetailsSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("OS details", null, 20, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.OSInformation".equals(typeName)) {
                try {
                    final String version = event.getString("osVersion");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(version);
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class CPUDetailsSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        CPUDetailsSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("CPU details", null, 10, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.CPUInformation".equals(typeName)) {
                try {
                    final String type = event.getString("cpu");
                    final int sockets = event.getInt("sockets");
                    final int cores = event.getInt("cores");
                    final int threads = event.getInt("hwThreads");
                    final String description = CPUDetailsSupport.formatDescription(event.getString("description"));
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText("<b>Chips:</b>&nbsp;" + sockets + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Cores:</b>&nbsp;" + cores + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Threads:</b>&nbsp;" + threads + "<br><br><b>Type:</b>&nbsp;" + type + "<br><br>" + description);
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private static String formatDescription(String description) {
            String[] parts;
            if (description.startsWith("Brand: ") && (parts = description.split("Supports: ")) != null && parts.length == 2) {
                return parts[0].replaceAll("((((?m)^)|(, ))(\\p{Upper}[^:,]+): )", "$2<b>$5:</b> ") + "<b>Supports:</b> " + parts[1];
            }
            return description;
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class MemoryUsageSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private SimpleXYChartSupport chartSupport;
        private List<Memory> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        MemoryUsageSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Memory usage", null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<Memory>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.PhysicalMemory".equals(typeName)) {
                try {
                    Memory record = new Memory(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            this.records.sort(TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (Memory record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.value});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long usedSize = lastEvent.getLong("usedSize");
                            long totalSize = lastEvent.getLong("totalSize");
                            chartSupport.updateDetails(new String[]{chartSupport.formatBytes(usedSize), chartSupport.formatBytes(totalSize)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                    records = null;
                }
            });
        }

        private void initModels() {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)Integer.MAX_VALUE);
            chartDescriptor.addLineFillItems(new String[]{"Used"});
            chartDescriptor.setDetailsItems(new String[]{"Used", "Total"});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
            this.chartSupport.setZoomingEnabled(true);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
            this.chartSupport.updateDetails(new String[]{"&lt;unknown&gt;"});
        }

        private static final class Memory
        extends TimeRecord {
            final long value;

            Memory(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.value = event.getLong("usedSize");
            }
        }
    }

    static class NetworkUtilizationSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private SimpleXYChartSupport chartSupport;
        private Map<Long, Network> records;

        NetworkUtilizationSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Network utilization", null, 20, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new TreeMap<Long, Network>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.NetworkUtilization".equals(typeName)) {
                try {
                    long time = TimeRecord.getTime(event, this.jfrModel);
                    Network network = this.records.get(time);
                    if (network == null) {
                        this.records.put(time, new Network(event, this.jfrModel));
                    } else {
                        network.add(event);
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Network last = null;
                    long lastTime = -9223372036854775807L;
                    Iterator iterator = records.values().iterator();
                    while (iterator.hasNext()) {
                        Network record;
                        last = record = (Network)iterator.next();
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.read, record.write});
                        lastTime = time;
                    }
                    if (last != null) {
                        records.clear();
                        String readDetail = chartSupport.formatBytes(last.read);
                        String writeDetail = chartSupport.formatBytes(last.write);
                        chartSupport.updateDetails(new String[]{readDetail, writeDetail});
                    }
                    records = null;
                }
            });
        }

        private void initModels() {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)Integer.MAX_VALUE);
            chartDescriptor.addLineItems(new String[]{"Read rate", "Write rate"});
            chartDescriptor.setDetailsItems(new String[]{"Read rate", "Write rate"});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
            this.chartSupport.setZoomingEnabled(true);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
            this.chartSupport.updateDetails(new String[]{"&lt;unknown&gt;", "&lt;unknown&gt;"});
        }

        private static final class Network
        extends TimeRecord {
            long read;
            long write;

            Network(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.read = event.getLong("readRate");
                this.write = event.getLong("writeRate");
            }

            void add(JFREvent event) {
                try {
                    long readRate = event.getLong("readRate");
                    long writeRate = event.getLong("writeRate");
                    this.read += readRate;
                    this.write += writeRate;
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
        }
    }

    static class CPUUtilizationSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private SimpleXYChartSupport chartSupport;
        private List<CPU> records;

        CPUUtilizationSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("CPU utilization", null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<CPU>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.CPULoad".equals(typeName)) {
                try {
                    this.records.add(new CPU(event, this.jfrModel));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            this.records.sort(TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (CPU record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.value});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        CPU last = (CPU)records.get(records.size() - 1);
                        records.clear();
                        String cpuDetail = chartSupport.formatPercent(last.value);
                        chartSupport.updateDetails(new String[]{cpuDetail});
                    }
                    records = null;
                }
            });
        }

        private void initModels() {
            SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.percent((boolean)false, (double)0.1, (int)Integer.MAX_VALUE);
            chartDescriptor.addLineItems(new String[]{"Machine"});
            chartDescriptor.setDetailsItems(new String[]{"Machine"});
            this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
            this.chartSupport.setZoomingEnabled(true);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
            this.chartSupport.updateDetails(new String[]{"&lt;unknown&gt;"});
        }

        private static final class CPU
        extends TimeRecord {
            final long value;

            CPU(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.value = Math.round(event.getFloat("machineTotal") * 1000.0f);
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel
    implements JFREventVisitor {
        private String osInfo = "<nobr><b>OS:</b> &lt;unknown&gt;</nbsp>";
        private String cpuInfo = "<nobr><b>CPU:</b> &lt;unknown&gt;</nbsp>";
        private String memInfo = "<nobr><b>Memory:</b> &lt;unknown&gt;</nbsp>";
        private HTMLTextArea area;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("Environment", null, (JComponent)this);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.OSInformation".equals(typeName)) {
                try {
                    this.osInfo = MasterViewSupport.formatOSInfo(event.getString("osVersion"));
                }
                catch (JFRPropertyNotAvailableException e) {
                    this.osInfo = "<not available>";
                }
            } else if ("jdk.CPUInformation".equals(typeName)) {
                try {
                    this.cpuInfo = MasterViewSupport.formatCPUInfo(event.getString("description"));
                }
                catch (JFRPropertyNotAvailableException e) {
                    this.osInfo = "<nobr><b>OS:</b> &lt;not available&gt;</nbsp>";
                }
            } else if ("jdk.PhysicalMemory".equals(typeName)) {
                try {
                    this.memInfo = MasterViewSupport.formatMemInfo(event.getLong("totalSize"));
                }
                catch (JFRPropertyNotAvailableException e) {
                    this.memInfo = "<nobr><b>Memory:</b> &lt;not available&gt;</nbsp>";
                }
            }
            return false;
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(cpuInfo + "<br>" + memInfo + "<br>" + osInfo);
                    osInfo = null;
                    cpuInfo = null;
                    memInfo = null;
                }
            });
        }

        private static String formatOSInfo(String os) {
            int i;
            String[] s = os.split("\\r?\\n");
            s[0] = s[0].trim();
            if (s[0].startsWith("OS:")) {
                s[0] = s[0].substring("OS:".length()).trim();
            }
            if (s[0].startsWith("uname:")) {
                s[0] = s[0].substring("uname:".length()).trim();
            }
            if (s[0].startsWith("Bsduname:")) {
                s[0] = s[0].substring("Bsduname:".length()).trim();
            }
            if (s[0].startsWith("DISTRIB_ID=")) {
                s[0] = s[0].substring("DISTRIB_ID=".length()).trim();
            }
            if (s[0].isEmpty() && s.length >= 2) {
                s[0] = s[1];
            }
            if ((i = s[0].indexOf(59)) > 0) {
                s[0] = s[0].substring(0, i).trim();
            }
            return "<nobr><b>OS:</b> " + s[0] + "</nbsp>";
        }

        private static String formatCPUInfo(String cpu) {
            String[] s = cpu.split("\\r?\\n");
            s[0] = s[0].trim();
            if (!s[0].startsWith("Brand:")) {
                return "<nobr><b>CPU:</b> " + s[0] + "</nbsp>";
            }
            s[0] = s[0].substring("Brand:".length()).trim();
            int i = s[0].indexOf(44);
            if (i > 0) {
                s[0] = s[0].substring(0, i).trim();
            }
            return "<nobr><b>CPU:</b> " + s[0] + "</nbsp>";
        }

        private static String formatMemInfo(Long mem) {
            String s = NumberFormat.getInstance().format(Math.ceil((double)mem.longValue() / 1024.0 / 1024.0 / 1024.0)) + " GB";
            return "<nobr><b>Memory:</b> " + s + " (" + Formatters.bytesFormat().format(new Object[]{mem}) + ")</nbsp>";
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else if (!model.containsEvent(JFRSnapshotEnvironmentViewProvider.EventChecker.class)) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("Environment", JFRSnapshotEnvironmentViewProvider.EventChecker.checkedTypes()), "Center");
            } else {
                this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr><br><br><br>");
                this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                this.add((Component)this.area, "Center");
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(this::firstShown);
                        }
                    }
                });
            }
        }
    }
}

