/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.step.BaseStep;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StepStatus {
    public static final String XML_TAG = "stepstatus";
    private String stepname;
    private int copy;
    private long linesRead;
    private long linesWritten;
    private long linesInput;
    private long linesOutput;
    private long linesUpdated;
    private long linesRejected;
    private long errors;
    private String statusDescription;
    private double seconds;
    private String speed;
    private String priority;
    private boolean stopped;
    private boolean paused;

    public StepStatus(BaseStep baseStep) {
        long in_proc = Math.max(baseStep.getLinesInput(), baseStep.getLinesRead());
        long out_proc = Math.max(baseStep.getLinesOutput() + baseStep.getLinesUpdated(), baseStep.getLinesWritten() + baseStep.getLinesRejected());
        float lapsed = (float)baseStep.getRuntime() / 1000.0f;
        double in_speed = 0.0;
        double out_speed = 0.0;
        if (lapsed != 0.0f) {
            in_speed = Math.floor(10.0f * ((float)in_proc / lapsed)) / 10.0;
            out_speed = Math.floor(10.0f * ((float)out_proc / lapsed)) / 10.0;
        }
        this.stepname = baseStep.getStepname();
        this.copy = baseStep.getCopy();
        this.linesRead = baseStep.getLinesRead();
        this.linesWritten = baseStep.getLinesWritten();
        this.linesInput = baseStep.getLinesInput();
        this.linesOutput = baseStep.getLinesOutput();
        this.linesUpdated = baseStep.getLinesUpdated();
        this.linesRejected = baseStep.getLinesRejected();
        this.errors = baseStep.getErrors();
        this.statusDescription = baseStep.getStatusDescription();
        this.seconds = Math.floor((double)(lapsed * 10.0f) + 0.5) / 10.0;
        this.speed = lapsed == 0.0f ? "-" : "   " + (in_speed > out_speed ? in_speed : out_speed);
        this.priority = baseStep.isAlive() ? "   " + baseStep.rowsetInputSize() + "/" + baseStep.rowsetOutputSize() : "-";
        this.stopped = baseStep.isStopped();
        this.paused = baseStep.isPaused();
    }

    public String getHTMLTableRow() {
        return "<tr> <th>" + this.stepname + "</th> " + "<th>" + this.copy + "</th> " + "<th>" + this.linesRead + "</th> " + "<th>" + this.linesWritten + "</th> " + "<th>" + this.linesInput + "</th> " + "<th>" + this.linesOutput + "</th> " + "<th>" + this.linesUpdated + "</th> " + "<th>" + this.linesRejected + "</th> " + "<th>" + this.errors + "</th> " + "<th>" + this.statusDescription + "</th> " + "<th>" + this.seconds + "</th> " + "<th>" + this.speed + "</th> " + "<th>" + this.priority + "</th> " + "</tr>";
    }

    public String getXML() {
        return "<stepstatus>" + XMLHandler.addTagValue((String)"stepname", (String)this.stepname, (boolean)false, (String[])new String[0]) + XMLHandler.addTagValue((String)"copy", (int)this.copy, (boolean)false) + XMLHandler.addTagValue((String)"linesRead", (long)this.linesRead, (boolean)false) + XMLHandler.addTagValue((String)"linesWritten", (long)this.linesWritten, (boolean)false) + XMLHandler.addTagValue((String)"linesInput", (long)this.linesInput, (boolean)false) + XMLHandler.addTagValue((String)"linesOutput", (long)this.linesOutput, (boolean)false) + XMLHandler.addTagValue((String)"linesUpdated", (long)this.linesUpdated, (boolean)false) + XMLHandler.addTagValue((String)"linesRejected", (long)this.linesRejected, (boolean)false) + XMLHandler.addTagValue((String)"errors", (long)this.errors, (boolean)false) + XMLHandler.addTagValue((String)"statusDescription", (String)this.statusDescription, (boolean)false, (String[])new String[0]) + XMLHandler.addTagValue((String)"seconds", (double)this.seconds, (boolean)false) + XMLHandler.addTagValue((String)"speed", (String)this.speed, (boolean)false, (String[])new String[0]) + XMLHandler.addTagValue((String)"priority", (String)this.priority, (boolean)false, (String[])new String[0]) + XMLHandler.addTagValue((String)"stopped", (boolean)this.stopped, (boolean)false) + XMLHandler.addTagValue((String)"paused", (boolean)this.paused, (boolean)false) + "</" + XML_TAG + ">";
    }

    public StepStatus(Node node) {
        this.stepname = XMLHandler.getTagValue((Node)node, (String)"stepname");
        this.copy = Integer.parseInt(XMLHandler.getTagValue((Node)node, (String)"copy"));
        this.linesRead = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesRead"));
        this.linesWritten = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesWritten"));
        this.linesInput = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesInput"));
        this.linesOutput = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesOutput"));
        this.linesUpdated = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesUpdated"));
        this.linesRejected = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"linesRejected"));
        this.errors = Long.parseLong(XMLHandler.getTagValue((Node)node, (String)"errors"));
        this.statusDescription = XMLHandler.getTagValue((Node)node, (String)"statusDescription");
        this.seconds = Double.parseDouble(XMLHandler.getTagValue((Node)node, (String)"seconds"));
        this.speed = XMLHandler.getTagValue((Node)node, (String)"speed");
        this.priority = XMLHandler.getTagValue((Node)node, (String)"priority");
        this.stopped = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"stopped"));
        this.paused = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"paused"));
    }

    public StepStatus fromXML(String xml) throws KettleXMLException {
        Document document = XMLHandler.loadXMLString((String)xml);
        return new StepStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    public String[] getTransLogFields() {
        String[] fields = new String[]{"", this.stepname, Integer.toString(this.copy), Long.toString(this.linesRead), Long.toString(this.linesWritten), Long.toString(this.linesInput), Long.toString(this.linesOutput), Long.toString(this.linesUpdated), Long.toString(this.linesRejected), Long.toString(this.errors), this.statusDescription, Double.toString(this.seconds), this.speed, this.priority};
        return fields;
    }

    public String[] getSpoonSlaveLogFields() {
        String[] fields = this.getTransLogFields();
        String[] retval = new String[fields.length - 1];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = fields[i + 1];
        }
        return retval;
    }

    public int getCopy() {
        return this.copy;
    }

    public void setCopy(int copy) {
        this.copy = copy;
    }

    public long getErrors() {
        return this.errors;
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    public long getLinesInput() {
        return this.linesInput;
    }

    public void setLinesInput(long linesInput) {
        this.linesInput = linesInput;
    }

    public long getLinesOutput() {
        return this.linesOutput;
    }

    public void setLinesOutput(long linesOutput) {
        this.linesOutput = linesOutput;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public void setLinesRead(long linesRead) {
        this.linesRead = linesRead;
    }

    public long getLinesUpdated() {
        return this.linesUpdated;
    }

    public void setLinesUpdated(long linesUpdated) {
        this.linesUpdated = linesUpdated;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public void setLinesWritten(long linesWritten) {
        this.linesWritten = linesWritten;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }

    public String getSpeed() {
        return this.speed;
    }

    public void setSpeed(String speed) {
        this.speed = speed;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getStepname() {
        return this.stepname;
    }

    public void setStepname(String stepname) {
        this.stepname = stepname;
    }

    public long getLinesRejected() {
        return this.linesRejected;
    }

    public void setLinesRejected(long linesRejected) {
        this.linesRejected = linesRejected;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

