/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.xtext.tasks.TaskTag;

public class TaskTags
implements Iterable<TaskTag> {
    private boolean caseSensitive;
    private final List<TaskTag> taskTags = new ArrayList<TaskTag>();
    private Pattern pattern;
    private Map<String, TaskTag> taskTagsByName;

    @Override
    public Iterator<TaskTag> iterator() {
        return this.taskTags.iterator();
    }

    public Pattern toPattern() {
        if (this.pattern == null) {
            int flags = 8;
            if (!this.caseSensitive) {
                flags = flags | 2 | 0x40;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("^.*((");
            String tagNames = this.taskTags.stream().map(it -> Pattern.quote(it.getName())).collect(Collectors.joining("|"));
            builder.append(tagNames);
            builder.append(")(.*)?)$");
            this.pattern = Pattern.compile(builder.toString(), flags);
        }
        return this.pattern;
    }

    public Map<String, TaskTag> getTaskTagsByName() {
        if (this.taskTagsByName == null) {
            HashMap<String, TaskTag> name2tag = new HashMap<String, TaskTag>();
            this.taskTagsByName = name2tag;
            for (TaskTag tag : this.taskTags) {
                String name = this.caseSensitive ? tag.getName() : tag.getName().toLowerCase();
                TaskTag oldTag = this.taskTagsByName.get(name);
                if (oldTag != null) {
                    if (tag.getPriority().ordinal() >= oldTag.getPriority().ordinal()) continue;
                    this.taskTagsByName.put(name, tag);
                    continue;
                }
                this.taskTagsByName.put(name, tag);
            }
        }
        return this.taskTagsByName;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public List<TaskTag> getTaskTags() {
        return this.taskTags;
    }
}

