/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.commons.net.pop3.POP3Command;
import org.apache.commons.net.util.NetConstants;

public class POP3
extends SocketClient {
    public static final int DEFAULT_PORT = 110;
    public static final int DISCONNECTED_STATE = -1;
    public static final int AUTHORIZATION_STATE = 0;
    public static final int TRANSACTION_STATE = 1;
    public static final int UPDATE_STATE = 2;
    static final String OK = "+OK";
    static final String OK_INT = "+ ";
    static final String ERROR = "-ERR";
    static final Charset DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    private int popState;
    BufferedWriter writer;
    BufferedReader reader;
    int replyCode;
    String lastReplyLine;
    List<String> replyLines;
    protected ProtocolCommandSupport _commandSupport_;

    public POP3() {
        this.setDefaultPort(110);
        this.popState = -1;
        this.reader = null;
        this.writer = null;
        this.replyLines = new ArrayList<String>();
        this._commandSupport_ = new ProtocolCommandSupport(this);
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this.reader = new CRLFLineReader(new InputStreamReader(this._input_, DEFAULT_ENCODING));
        this.writer = new BufferedWriter(new OutputStreamWriter(this._output_, DEFAULT_ENCODING));
        this.getReply();
        this.setState(0);
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.reader = null;
        this.writer = null;
        this.lastReplyLine = null;
        this.replyLines.clear();
        this.setState(-1);
    }

    public void getAdditionalReply() throws IOException {
        String line = this.reader.readLine();
        while (line != null) {
            this.replyLines.add(line);
            if (line.equals(".")) break;
            line = this.reader.readLine();
        }
    }

    @Override
    protected ProtocolCommandSupport getCommandSupport() {
        return this._commandSupport_;
    }

    private void getReply() throws IOException {
        this.replyLines.clear();
        String line = this.reader.readLine();
        if (line == null) {
            throw new EOFException("Connection closed without indication.");
        }
        if (line.startsWith(OK)) {
            this.replyCode = 0;
        } else if (line.startsWith(ERROR)) {
            this.replyCode = 1;
        } else if (line.startsWith(OK_INT)) {
            this.replyCode = 2;
        } else {
            throw new MalformedServerReplyException("Received invalid POP3 protocol response from server." + line);
        }
        this.replyLines.add(line);
        this.lastReplyLine = line;
        this.fireReplyReceived(this.replyCode, this.getReplyString());
    }

    public String getReplyString() {
        StringBuilder buffer = new StringBuilder(256);
        for (String entry : this.replyLines) {
            buffer.append(entry);
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public String[] getReplyStrings() {
        return this.replyLines.toArray(NetConstants.EMPTY_STRING_ARRAY);
    }

    public int getState() {
        return this.popState;
    }

    public void removeProtocolCommandistener(ProtocolCommandListener listener) {
        this.removeProtocolCommandListener(listener);
    }

    public int sendCommand(int command) throws IOException {
        return this.sendCommand(POP3Command.commands[command], null);
    }

    public int sendCommand(int command, String args) throws IOException {
        return this.sendCommand(POP3Command.commands[command], args);
    }

    public int sendCommand(String command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(String command, String args) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("Socket is not connected");
        }
        StringBuilder builder = new StringBuilder(command);
        if (args != null) {
            builder.append(' ');
            builder.append(args);
        }
        builder.append("\r\n");
        String message = builder.toString();
        this.writer.write(message);
        this.writer.flush();
        this.fireCommandSent(command, message);
        this.getReply();
        return this.replyCode;
    }

    public void setState(int state) {
        this.popState = state;
    }
}

