/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.openide.text.Annotatable;
import org.openide.text.LineVector;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class Line
extends Annotatable
implements Serializable {
    private static final long serialVersionUID = 9113186289600795476L;
    static final Logger LOG = Logger.getLogger(Line.class.getName());
    public static final String PROP_LINE_NUMBER = "lineNumber";
    @Deprecated
    public static final int SHOW_TRY_SHOW = 0;
    @Deprecated
    public static final int SHOW_SHOW = 1;
    @Deprecated
    public static final int SHOW_GOTO = 2;
    @Deprecated
    public static final int SHOW_TOFRONT = 3;
    @Deprecated
    public static final int SHOW_REUSE = 4;
    @Deprecated
    public static final int SHOW_REUSE_NEW = 5;
    private static final Part nullPart = new NullPart();
    private Lookup dataObject;

    public Line(Lookup lookup) {
        if (lookup == null) {
            throw new NullPointerException();
        }
        this.dataObject = lookup;
    }

    public Line(Object object) {
        this(object instanceof Lookup ? (Lookup)object : Lookups.singleton((Object)object));
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public String getDisplayName() {
        return this.getClass().getName() + ":" + this.getLineNumber();
    }

    public final Lookup getLookup() {
        return this.dataObject;
    }

    public abstract int getLineNumber();

    @Deprecated
    public abstract void show(int var1, int var2);

    @Deprecated
    public void show(int n) {
        this.show(n, 0);
    }

    public void show(ShowOpenType showOpenType, ShowVisibilityType showVisibilityType, int n) {
        if (showOpenType == ShowOpenType.NONE) {
            if (showVisibilityType == ShowVisibilityType.NONE) {
                this.show(0, n);
            } else {
                LOG.warning("Line.show(ShowOpenType, ShowVisibilityType, int) uses unsupported combination of parameters");
                this.show(0, n);
            }
        } else if (showOpenType == ShowOpenType.OPEN) {
            if (showVisibilityType == ShowVisibilityType.NONE) {
                this.show(1, n);
            } else if (showVisibilityType == ShowVisibilityType.FOCUS) {
                this.show(2, n);
            } else if (showVisibilityType == ShowVisibilityType.FRONT) {
                this.show(3, n);
            }
        } else if (showOpenType == ShowOpenType.REUSE) {
            if (showVisibilityType == ShowVisibilityType.FOCUS) {
                this.show(4, n);
            } else {
                LOG.warning("Line.show(ShowOpenType, ShowVisibilityType, int) uses unsupported combination of parameters");
                this.show(4, n);
            }
        } else if (showOpenType == ShowOpenType.REUSE_NEW) {
            if (showVisibilityType == ShowVisibilityType.FOCUS) {
                this.show(5, n);
            } else {
                LOG.warning("Line.show(ShowOpenType, ShowVisibilityType, int) uses unsupported combination of parameters");
                this.show(5, n);
            }
        }
    }

    public void show(ShowOpenType showOpenType, ShowVisibilityType showVisibilityType) {
        this.show(showOpenType, showVisibilityType, 0);
    }

    @Deprecated
    public abstract void setBreakpoint(boolean var1);

    @Deprecated
    public abstract boolean isBreakpoint();

    @Deprecated
    public abstract void markError();

    @Deprecated
    public abstract void unmarkError();

    @Deprecated
    public abstract void markCurrentLine();

    @Deprecated
    public abstract void unmarkCurrentLine();

    @Deprecated
    public boolean canBeMarkedCurrent(int n, Line line) {
        return true;
    }

    public Part createPart(int n, int n2) {
        return nullPart;
    }

    @Override
    public String getText() {
        return null;
    }

    public static abstract class Set {
        private Date date = new Date();
        private LineVector lineVector;

        public abstract List<? extends Line> getLines();

        public final Date getDate() {
            return this.date;
        }

        public abstract Line getOriginal(int var1) throws IndexOutOfBoundsException;

        public abstract Line getCurrent(int var1) throws IndexOutOfBoundsException;

        public int getOriginalLineNumber(Line line) {
            return Set.computeOriginal(this, line);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LineVector findLineVector() {
            Date date = this.date;
            synchronized (date) {
                if (this.lineVector != null) {
                    return this.lineVector;
                }
                this.lineVector = new LineVector();
                return this.lineVector;
            }
        }

        final Line findOrCreateLine(int n, LineVector.LineCreator lineCreator) {
            if (lineCreator == null) {
                throw new NullPointerException();
            }
            LineVector lineVector = this.findLineVector();
            return lineVector.findOrCreateLine(n, lineCreator);
        }

        final Line findLine(Line line) {
            LineVector lineVector = this.findLineVector();
            return lineVector.findOrCreateLine(line.getLineNumber(), null);
        }

        static int computeOriginal(Set set, Line line) {
            int n = line.getLineNumber();
            Line line2 = null;
            try {
                line2 = set.getOriginal(n);
                if (line.equals(line2)) {
                    return n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (line2 == null) {
                return Set.binarySearch(set, n, 0, Set.findMaxLine(set));
            }
            if (n < line2.getLineNumber()) {
                return Set.binarySearch(set, n, 0, line2.getLineNumber());
            }
            return Set.binarySearch(set, n, line2.getLineNumber(), Set.findMaxLine(set));
        }

        private static int binarySearch(Set set, int n, int n2, int n3) {
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                Line line = set.getOriginal(n4);
                int n5 = line.getLineNumber();
                if (n5 == n) {
                    return n4;
                }
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                n3 = n4 - 1;
            }
            return n2;
        }

        private static int findMaxLine(Set set) {
            int n = 0;
            int n2 = 32000;
            try {
                while (true) {
                    set.getOriginal(n2);
                    n = n2;
                    n2 *= 2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                while (n < n2) {
                    int n3 = (n + n2 + 1) / 2;
                    try {
                        set.getOriginal(n3);
                        n = n3;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                        n2 = n3 - 1;
                    }
                }
                return n;
            }
        }
    }

    private static final class NullPart
    extends Part {
        NullPart() {
        }

        @Override
        public int getColumn() {
            return 0;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Line getLine() {
            return null;
        }

        @Override
        public String getText() {
            return null;
        }
    }

    public static abstract class Part
    extends Annotatable {
        public static final String PROP_LINE = "line";
        public static final String PROP_COLUMN = "column";
        public static final String PROP_LENGTH = "length";

        public abstract int getColumn();

        public abstract int getLength();

        public abstract Line getLine();
    }

    public static enum ShowVisibilityType {
        NONE,
        FRONT,
        FOCUS;

    }

    public static enum ShowOpenType {
        NONE,
        OPEN,
        REUSE,
        REUSE_NEW;

    }
}

