/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssHangingPunctuation
extends org.w3c.css.properties.css.CssHangingPunctuation {
    public static final CssIdent first = CssIdent.getIdent("first");
    public static final CssIdent last = CssIdent.getIdent("last");
    public static final CssIdent[] endValues;
    public static final CssIdent none;

    public static final CssIdent getEndValue(CssIdent ident) {
        for (CssIdent id : endValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssHangingPunctuation() {
    }

    public CssHangingPunctuation(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue firstValue = null;
        CssValue lastValue = null;
        CssValue endValue = null;
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        CssIdent ident = val.getIdent();
        if (CssIdent.isCssWide(ident)) {
            this.value = val;
            if (check && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else if (none.equals(ident)) {
            this.value = val;
            if (check && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else {
            int nbgot = 0;
            do {
                boolean match = false;
                if (firstValue == null && first.equals(ident)) {
                    firstValue = val;
                    match = true;
                } else if (lastValue == null && last.equals(ident)) {
                    lastValue = val;
                    match = true;
                } else if (endValue == null && CssHangingPunctuation.getEndValue(ident) != null) {
                    endValue = val;
                    match = true;
                }
                if (!match) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (expression.getRemainingCount() == 1 || !check && ++nbgot == 3) break;
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                expression.next();
                val = expression.getValue();
                op = expression.getOperator();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                ident = val.getIdent();
            } while (!expression.end());
            ArrayList<CssValue> v = new ArrayList<CssValue>(nbgot);
            if (firstValue != null) {
                v.add(firstValue);
            }
            if (endValue != null) {
                v.add(endValue);
            }
            if (lastValue != null) {
                v.add(lastValue);
            }
            this.value = nbgot > 1 ? new CssValueList(v) : (CssValue)v.get(0);
        }
        expression.next();
    }

    public CssHangingPunctuation(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        none = CssIdent.getIdent("none");
        String[] _endValues = new String[]{"force-end", "allow-end"};
        endValues = new CssIdent[_endValues.length];
        int i = 0;
        for (String s : _endValues) {
            CssHangingPunctuation.endValues[i++] = CssIdent.getIdent(s);
        }
    }
}

