<?php
/**
 * NotificationEndpointsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * NotificationEndpointsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class NotificationEndpointsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation createNotificationEndpoint
     *
     * Add a notification endpoint
     *
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint Notification endpoint to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error
     */
    public function createNotificationEndpoint($notification_endpoint)
    {
        list($response) = $this->createNotificationEndpointWithHttpInfo($notification_endpoint);
        return $response;
    }

    /**
     * Operation createNotificationEndpointWithHttpInfo
     *
     * Add a notification endpoint
     *
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint Notification endpoint to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createNotificationEndpointWithHttpInfo($notification_endpoint)
    {
        $request = $this->createNotificationEndpointRequest($notification_endpoint);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationEndpoint';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'createNotificationEndpoint'
     *
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint Notification endpoint to create (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function createNotificationEndpointRequest($notification_endpoint)
    {
        // verify the required parameter 'notification_endpoint' is set
        if ($notification_endpoint === null || (is_array($notification_endpoint) && count($notification_endpoint) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_endpoint when calling createNotificationEndpoint'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($notification_endpoint)) {
            $_tempBody = $notification_endpoint;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteNotificationEndpointsID
     *
     * Delete a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteNotificationEndpointsID($endpoint_id, $zap_trace_span = null)
    {
        $this->deleteNotificationEndpointsIDWithHttpInfo($endpoint_id, $zap_trace_span);
    }

    /**
     * Operation deleteNotificationEndpointsIDWithHttpInfo
     *
     * Delete a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteNotificationEndpointsIDWithHttpInfo($endpoint_id, $zap_trace_span = null)
    {
        $request = $this->deleteNotificationEndpointsIDRequest($endpoint_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteNotificationEndpointsID'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteNotificationEndpointsIDRequest($endpoint_id, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling deleteNotificationEndpointsID'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteNotificationEndpointsIDLabelsID
     *
     * Delete a label from a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteNotificationEndpointsIDLabelsID($endpoint_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteNotificationEndpointsIDLabelsIDWithHttpInfo($endpoint_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteNotificationEndpointsIDLabelsIDWithHttpInfo
     *
     * Delete a label from a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteNotificationEndpointsIDLabelsIDWithHttpInfo($endpoint_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteNotificationEndpointsIDLabelsIDRequest($endpoint_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteNotificationEndpointsIDLabelsID'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteNotificationEndpointsIDLabelsIDRequest($endpoint_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling deleteNotificationEndpointsIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteNotificationEndpointsIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationEndpoints
     *
     * List all notification endpoints
     *
     * @param  string $org_id Only show notification endpoints that belong to specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationEndpoints|\InfluxDB2\Model\Error
     */
    public function getNotificationEndpoints($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        list($response) = $this->getNotificationEndpointsWithHttpInfo($org_id, $zap_trace_span, $offset, $limit);
        return $response;
    }

    /**
     * Operation getNotificationEndpointsWithHttpInfo
     *
     * List all notification endpoints
     *
     * @param  string $org_id Only show notification endpoints that belong to specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationEndpoints|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationEndpointsWithHttpInfo($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        $request = $this->getNotificationEndpointsRequest($org_id, $zap_trace_span, $offset, $limit);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationEndpoints';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationEndpoints'
     *
     * @param  string $org_id Only show notification endpoints that belong to specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationEndpointsRequest($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getNotificationEndpoints'
            );
        }
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling NotificationEndpointsService.getNotificationEndpoints, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling NotificationEndpointsService.getNotificationEndpoints, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling NotificationEndpointsService.getNotificationEndpoints, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/notificationEndpoints';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationEndpointsID
     *
     * Retrieve a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error
     */
    public function getNotificationEndpointsID($endpoint_id, $zap_trace_span = null)
    {
        list($response) = $this->getNotificationEndpointsIDWithHttpInfo($endpoint_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getNotificationEndpointsIDWithHttpInfo
     *
     * Retrieve a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationEndpointsIDWithHttpInfo($endpoint_id, $zap_trace_span = null)
    {
        $request = $this->getNotificationEndpointsIDRequest($endpoint_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationEndpoint';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationEndpointsID'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationEndpointsIDRequest($endpoint_id, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling getNotificationEndpointsID'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getNotificationEndpointsIDLabels
     *
     * List all labels for a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getNotificationEndpointsIDLabels($endpoint_id, $zap_trace_span = null)
    {
        list($response) = $this->getNotificationEndpointsIDLabelsWithHttpInfo($endpoint_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getNotificationEndpointsIDLabelsWithHttpInfo
     *
     * List all labels for a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationEndpointsIDLabelsWithHttpInfo($endpoint_id, $zap_trace_span = null)
    {
        $request = $this->getNotificationEndpointsIDLabelsRequest($endpoint_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getNotificationEndpointsIDLabels'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getNotificationEndpointsIDLabelsRequest($endpoint_id, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling getNotificationEndpointsIDLabels'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchNotificationEndpointsID
     *
     * Update a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpointUpdate $notification_endpoint_update Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchNotificationEndpointsID($endpoint_id, $notification_endpoint_update, $zap_trace_span = null)
    {
        list($response) = $this->patchNotificationEndpointsIDWithHttpInfo($endpoint_id, $notification_endpoint_update, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchNotificationEndpointsIDWithHttpInfo
     *
     * Update a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpointUpdate $notification_endpoint_update Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchNotificationEndpointsIDWithHttpInfo($endpoint_id, $notification_endpoint_update, $zap_trace_span = null)
    {
        $request = $this->patchNotificationEndpointsIDRequest($endpoint_id, $notification_endpoint_update, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationEndpoint';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchNotificationEndpointsID'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpointUpdate $notification_endpoint_update Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchNotificationEndpointsIDRequest($endpoint_id, $notification_endpoint_update, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling patchNotificationEndpointsID'
            );
        }
        // verify the required parameter 'notification_endpoint_update' is set
        if ($notification_endpoint_update === null || (is_array($notification_endpoint_update) && count($notification_endpoint_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_endpoint_update when calling patchNotificationEndpointsID'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($notification_endpoint_update)) {
            $_tempBody = $notification_endpoint_update;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postNotificationEndpointIDLabels
     *
     * Add a label to a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postNotificationEndpointIDLabels($endpoint_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postNotificationEndpointIDLabelsWithHttpInfo($endpoint_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postNotificationEndpointIDLabelsWithHttpInfo
     *
     * Add a label to a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postNotificationEndpointIDLabelsWithHttpInfo($endpoint_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postNotificationEndpointIDLabelsRequest($endpoint_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postNotificationEndpointIDLabels'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postNotificationEndpointIDLabelsRequest($endpoint_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling postNotificationEndpointIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postNotificationEndpointIDLabels'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putNotificationEndpointsID
     *
     * Update a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint A new notification endpoint to replace the existing endpoint with (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function putNotificationEndpointsID($endpoint_id, $notification_endpoint, $zap_trace_span = null)
    {
        list($response) = $this->putNotificationEndpointsIDWithHttpInfo($endpoint_id, $notification_endpoint, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putNotificationEndpointsIDWithHttpInfo
     *
     * Update a notification endpoint
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint A new notification endpoint to replace the existing endpoint with (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\NotificationEndpoint|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putNotificationEndpointsIDWithHttpInfo($endpoint_id, $notification_endpoint, $zap_trace_span = null)
    {
        $request = $this->putNotificationEndpointsIDRequest($endpoint_id, $notification_endpoint, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\NotificationEndpoint';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putNotificationEndpointsID'
     *
     * @param  string $endpoint_id The notification endpoint ID. (required)
     * @param  \InfluxDB2\Model\NotificationEndpoint $notification_endpoint A new notification endpoint to replace the existing endpoint with (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putNotificationEndpointsIDRequest($endpoint_id, $notification_endpoint, $zap_trace_span = null)
    {
        // verify the required parameter 'endpoint_id' is set
        if ($endpoint_id === null || (is_array($endpoint_id) && count($endpoint_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $endpoint_id when calling putNotificationEndpointsID'
            );
        }
        // verify the required parameter 'notification_endpoint' is set
        if ($notification_endpoint === null || (is_array($notification_endpoint) && count($notification_endpoint) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $notification_endpoint when calling putNotificationEndpointsID'
            );
        }

        $resourcePath = '/api/v2/notificationEndpoints/{endpointID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($endpoint_id !== null) {
            $resourcePath = str_replace(
                '{' . 'endpointID' . '}',
                ObjectSerializer::toPathValue($endpoint_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($notification_endpoint)) {
            $_tempBody = $notification_endpoint;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
