<?php
/**
 * OrganizationsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * OrganizationsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrganizationsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteOrgsID
     *
     * Delete an organization
     *
     * @param  string $org_id The ID of the organization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsID($org_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDWithHttpInfo($org_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDWithHttpInfo
     *
     * Delete an organization
     *
     * @param  string $org_id The ID of the organization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsID'
     *
     * @param  string $org_id The ID of the organization to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteOrgsIDMembersID
     *
     * Remove a member from an organization
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsIDMembersID($user_id, $org_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDMembersIDWithHttpInfo($user_id, $org_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDMembersIDWithHttpInfo
     *
     * Remove a member from an organization
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDMembersIDWithHttpInfo($user_id, $org_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDMembersIDRequest($user_id, $org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsIDMembersID'
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDMembersIDRequest($user_id, $org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteOrgsIDMembersID'
            );
        }
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsIDMembersID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteOrgsIDOwnersID
     *
     * Remove an owner from an organization
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsIDOwnersID($user_id, $org_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDOwnersIDWithHttpInfo($user_id, $org_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDOwnersIDWithHttpInfo
     *
     * Remove an owner from an organization
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDOwnersIDWithHttpInfo($user_id, $org_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDOwnersIDRequest($user_id, $org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDOwnersIDRequest($user_id, $org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteOrgsIDOwnersID'
            );
        }
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgs
     *
     * List organizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organizations|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getOrgs($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        list($response) = $this->getOrgsWithHttpInfo($zap_trace_span, $offset, $limit, $descending, $org, $org_id, $user_id);
        return $response;
    }

    /**
     * Operation getOrgsWithHttpInfo
     *
     * List organizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organizations|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsWithHttpInfo($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        $request = $this->getOrgsRequest($zap_trace_span, $offset, $limit, $descending, $org, $org_id, $user_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organizations';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgs'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsRequest($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling OrganizationsService.getOrgs, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling OrganizationsService.getOrgs, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling OrganizationsService.getOrgs, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/orgs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($descending !== null) {
            $queryParams['descending'] = ObjectSerializer::toQueryValue($descending);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($user_id !== null) {
            $queryParams['userID'] = ObjectSerializer::toQueryValue($user_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsID
     *
     * Retrieve an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error
     */
    public function getOrgsID($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDWithHttpInfo
     *
     * Retrieve an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsID'
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsIDMembers
     *
     * List all members of an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getOrgsIDMembers($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDMembersWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDMembersWithHttpInfo
     *
     * List all members of an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDMembersWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDMembersRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsIDMembers'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDMembersRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsIDMembers'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsIDOwners
     *
     * List all owners of an organization
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getOrgsIDOwners($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDOwnersWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDOwnersWithHttpInfo
     *
     * List all owners of an organization
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDOwnersWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDOwnersRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsIDOwners'
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDOwnersRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsIDOwners'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchOrgsID
     *
     * Update an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  \InfluxDB2\Model\PatchOrganizationRequest $patch_organization_request Organization update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error
     */
    public function patchOrgsID($org_id, $patch_organization_request, $zap_trace_span = null)
    {
        list($response) = $this->patchOrgsIDWithHttpInfo($org_id, $patch_organization_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchOrgsIDWithHttpInfo
     *
     * Update an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  \InfluxDB2\Model\PatchOrganizationRequest $patch_organization_request Organization update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchOrgsIDWithHttpInfo($org_id, $patch_organization_request, $zap_trace_span = null)
    {
        $request = $this->patchOrgsIDRequest($org_id, $patch_organization_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchOrgsID'
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  \InfluxDB2\Model\PatchOrganizationRequest $patch_organization_request Organization update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchOrgsIDRequest($org_id, $patch_organization_request, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling patchOrgsID'
            );
        }
        // verify the required parameter 'patch_organization_request' is set
        if ($patch_organization_request === null || (is_array($patch_organization_request) && count($patch_organization_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $patch_organization_request when calling patchOrgsID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($patch_organization_request)) {
            $_tempBody = $patch_organization_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postOrgs
     *
     * Create an organization
     *
     * @param  \InfluxDB2\Model\PostOrganizationRequest $post_organization_request The organization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function postOrgs($post_organization_request, $zap_trace_span = null)
    {
        list($response) = $this->postOrgsWithHttpInfo($post_organization_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postOrgsWithHttpInfo
     *
     * Create an organization
     *
     * @param  \InfluxDB2\Model\PostOrganizationRequest $post_organization_request The organization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postOrgsWithHttpInfo($post_organization_request, $zap_trace_span = null)
    {
        $request = $this->postOrgsRequest($post_organization_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postOrgs'
     *
     * @param  \InfluxDB2\Model\PostOrganizationRequest $post_organization_request The organization to create. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postOrgsRequest($post_organization_request, $zap_trace_span = null)
    {
        // verify the required parameter 'post_organization_request' is set
        if ($post_organization_request === null || (is_array($post_organization_request) && count($post_organization_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $post_organization_request when calling postOrgs'
            );
        }

        $resourcePath = '/api/v2/orgs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($post_organization_request)) {
            $_tempBody = $post_organization_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postOrgsIDMembers
     *
     * Add a member to an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error
     */
    public function postOrgsIDMembers($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postOrgsIDMembersWithHttpInfo($org_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postOrgsIDMembersWithHttpInfo
     *
     * Add a member to an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postOrgsIDMembersWithHttpInfo($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postOrgsIDMembersRequest($org_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postOrgsIDMembers'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postOrgsIDMembersRequest($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling postOrgsIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postOrgsIDMembers'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postOrgsIDOwners
     *
     * Add an owner to an organization
     *
     * @param  string $org_id The ID of the organization that you want to add an owner for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body The user to add as an owner of the organization. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error
     */
    public function postOrgsIDOwners($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postOrgsIDOwnersWithHttpInfo($org_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postOrgsIDOwnersWithHttpInfo
     *
     * Add an owner to an organization
     *
     * @param  string $org_id The ID of the organization that you want to add an owner for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body The user to add as an owner of the organization. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postOrgsIDOwnersWithHttpInfo($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postOrgsIDOwnersRequest($org_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postOrgsIDOwners'
     *
     * @param  string $org_id The ID of the organization that you want to add an owner for. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body The user to add as an owner of the organization. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postOrgsIDOwnersRequest($org_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling postOrgsIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postOrgsIDOwners'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
