/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect.df;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.internal.impl.collect.df.NodeStack;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.version.Version;

@Singleton
@Named(value="df")
public class DfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    public static final String NAME = "df";

    @Deprecated
    public DfDependencyCollector() {
    }

    @Inject
    DfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session2, RequestTrace trace2, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node2, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        NodeStack nodes2 = new NodeStack();
        nodes2.push(node2);
        Args args = new Args(session2, pool, nodes2, context, versionContext, request);
        this.process(args, trace2, results, dependencies, repositories, session2.getDependencySelector() != null ? session2.getDependencySelector().deriveChildSelector(context) : null, session2.getDependencyManager() != null ? session2.getDependencyManager().deriveChildManager(context) : null, session2.getDependencyTraverser() != null ? session2.getDependencyTraverser().deriveChildTraverser(context) : null, session2.getVersionFilter() != null ? session2.getVersionFilter().deriveChildFilter(context) : null);
    }

    private void process(Args args, RequestTrace trace2, DependencyCollectorDelegate.Results results, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter) {
        for (Dependency dependency : dependencies) {
            this.processDependency(args, trace2, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency);
        }
    }

    private void processDependency(Args args, RequestTrace trace2, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency) {
        List<Artifact> relocations = Collections.emptyList();
        this.processDependency(args, trace2, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency, relocations, false);
    }

    private void processDependency(Args args, RequestTrace parent, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency, List<Artifact> relocations, boolean disableVersionManagement) {
        List<? extends Version> versions;
        VersionRangeResult rangeResult;
        if (depSelector != null && !depSelector.selectDependency(dependency)) {
            return;
        }
        RequestTrace trace2 = this.collectStepTrace(parent, args.request.getRequestContext(), args.nodes.nodes, dependency);
        PremanagedDependency preManaged = PremanagedDependency.create(depManager, dependency, disableVersionManagement, args.premanagedState);
        boolean noDescriptor = DfDependencyCollector.isLackingDescriptor((dependency = preManaged.getManagedDependency()).getArtifact());
        boolean traverse = !noDescriptor && (depTraverser == null || depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = DfDependencyCollector.createVersionRangeRequest(args.request.getRequestContext(), trace2, repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args.pool, args.session);
            versions = DfDependencyCollector.filterVersions(dependency, rangeResult, verFilter, args.versionContext);
        }
        catch (VersionRangeResolutionException e2) {
            results.addException(dependency, e2, args.nodes.nodes);
            return;
        }
        for (Version version : versions) {
            ArtifactDescriptorRequest descriptorRequest;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = this.getArtifactDescriptorResult(args, results, noDescriptor, d, descriptorRequest = DfDependencyCollector.createArtifactDescriptorRequest(args.request.getRequestContext(), trace2, repositories, d));
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                d = d.setArtifact(descriptorResult.getArtifact());
                DependencyNode node2 = args.nodes.top();
                int cycleEntry = DefaultDependencyCycle.find(args.nodes.nodes, d.getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(args.nodes.nodes, cycleEntry, d);
                    DependencyNode cycleNode = args.nodes.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        node2.getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    this.processDependency(args, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
                child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args.request.getRequestContext());
                node2.getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                if (!recurse) continue;
                this.doRecurse(args, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult, child);
                continue;
            }
            DependencyNode node2 = args.nodes.top();
            List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
            DefaultDependencyNode child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args.request.getRequestContext());
            node2.getChildren().add(child);
        }
    }

    private void doRecurse(Args args, RequestTrace trace2, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency d, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args.collectionContext;
        context.set(d, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = depSelector != null ? depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = depManager != null ? depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = depTraverser != null ? depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = verFilter != null ? verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args.ignoreRepos ? repositories : this.remoteRepositoryManager.aggregateRepositories(args.session, repositories, descriptorResult.getRepositories(), true);
        Object key2 = args.pool.toKey(d.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children2 = args.pool.getChildren(key2);
        if (children2 == null) {
            args.pool.putChildren(key2, child.getChildren());
            args.nodes.push(child);
            this.process(args, trace2, results, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser, childFilter);
            args.nodes.pop();
        } else {
            child.setChildren(children2);
        }
    }

    private ArtifactDescriptorResult getArtifactDescriptorResult(Args args, DependencyCollectorDelegate.Results results, boolean noDescriptor, Dependency d, ArtifactDescriptorRequest descriptorRequest) {
        return noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args.pool, descriptorRequest, args.session, d, results, args);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session2, Dependency d, DependencyCollectorDelegate.Results results, Args args) {
        Object key2 = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key2, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
                pool.putDescriptor(key2, descriptorResult);
            }
            catch (ArtifactDescriptorException e2) {
                results.addException(d, e2, args.nodes.nodes);
                pool.putDescriptor(key2, e2);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final NodeStack nodes;
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;

        Args(RepositorySystemSession session2, DataPool pool, NodeStack nodes2, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request) {
            this.session = session2;
            this.request = request;
            this.ignoreRepos = session2.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session2, false, "aether.dependencyManager.verbose");
            this.pool = pool;
            this.nodes = nodes2;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
        }
    }
}

