// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, SidebarSection};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSidebarItem")]
    pub struct SidebarItem(Object<ffi::AdwSidebarItem, ffi::AdwSidebarItemClass>);

    match fn {
        type_ => || ffi::adw_sidebar_item_get_type(),
    }
}

impl SidebarItem {
    pub const NONE: Option<&'static SidebarItem> = None;

    #[doc(alias = "adw_sidebar_item_new")]
    pub fn new(title: &str) -> SidebarItem {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::adw_sidebar_item_new(title.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SidebarItem`] objects.
    ///
    /// This method returns an instance of [`SidebarItemBuilder`](crate::builders::SidebarItemBuilder) which can be used to create [`SidebarItem`] objects.
    pub fn builder() -> SidebarItemBuilder {
        SidebarItemBuilder::new()
    }
}

#[cfg(feature = "v1_9")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
impl Default for SidebarItem {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SidebarItem`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SidebarItemBuilder {
    builder: glib::object::ObjectBuilder<'static, SidebarItem>,
}

impl SidebarItemBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn drag_motion_activate(self, drag_motion_activate: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("drag-motion-activate", drag_motion_activate),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn enabled(self, enabled: bool) -> Self {
        Self {
            builder: self.builder.property("enabled", enabled),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn icon_paintable(self, icon_paintable: &impl IsA<gdk::Paintable>) -> Self {
        Self {
            builder: self
                .builder
                .property("icon-paintable", icon_paintable.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn subtitle(self, subtitle: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("subtitle", subtitle.into()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn suffix(self, suffix: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("suffix", suffix.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn tooltip(self, tooltip: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip", tooltip.into()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SidebarItem`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SidebarItem {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait SidebarItemExt: IsA<SidebarItem> + 'static {
    #[doc(alias = "adw_sidebar_item_get_drag_motion_activate")]
    #[doc(alias = "get_drag_motion_activate")]
    #[doc(alias = "drag-motion-activate")]
    fn is_drag_motion_activate(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_sidebar_item_get_drag_motion_activate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_enabled")]
    #[doc(alias = "get_enabled")]
    #[doc(alias = "enabled")]
    fn is_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_sidebar_item_get_enabled(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    #[doc(alias = "icon-name")]
    fn icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_icon_paintable")]
    #[doc(alias = "get_icon_paintable")]
    #[doc(alias = "icon-paintable")]
    fn icon_paintable(&self) -> Option<gdk::Paintable> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_icon_paintable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_index")]
    #[doc(alias = "get_index")]
    fn index(&self) -> u32 {
        unsafe { ffi::adw_sidebar_item_get_index(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "adw_sidebar_item_get_section")]
    #[doc(alias = "get_section")]
    fn section(&self) -> Option<SidebarSection> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_section(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_section_index")]
    #[doc(alias = "get_section_index")]
    fn section_index(&self) -> u32 {
        unsafe { ffi::adw_sidebar_item_get_section_index(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "adw_sidebar_item_get_subtitle")]
    #[doc(alias = "get_subtitle")]
    fn subtitle(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_subtitle(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_suffix")]
    #[doc(alias = "get_suffix")]
    fn suffix(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_suffix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_tooltip")]
    #[doc(alias = "get_tooltip")]
    fn tooltip(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_sidebar_item_get_tooltip(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_use_underline")]
    #[doc(alias = "get_use_underline")]
    #[doc(alias = "use-underline")]
    fn uses_underline(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_sidebar_item_get_use_underline(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_get_visible")]
    #[doc(alias = "get_visible")]
    #[doc(alias = "visible")]
    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_sidebar_item_get_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_sidebar_item_set_drag_motion_activate")]
    #[doc(alias = "drag-motion-activate")]
    fn set_drag_motion_activate(&self, drag_motion_activate: bool) {
        unsafe {
            ffi::adw_sidebar_item_set_drag_motion_activate(
                self.as_ref().to_glib_none().0,
                drag_motion_activate.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_enabled")]
    #[doc(alias = "enabled")]
    fn set_enabled(&self, enabled: bool) {
        unsafe {
            ffi::adw_sidebar_item_set_enabled(self.as_ref().to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "adw_sidebar_item_set_icon_name")]
    #[doc(alias = "icon-name")]
    fn set_icon_name(&self, icon_name: Option<&str>) {
        unsafe {
            ffi::adw_sidebar_item_set_icon_name(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_icon_paintable")]
    #[doc(alias = "icon-paintable")]
    fn set_icon_paintable(&self, paintable: Option<&impl IsA<gdk::Paintable>>) {
        unsafe {
            ffi::adw_sidebar_item_set_icon_paintable(
                self.as_ref().to_glib_none().0,
                paintable.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_subtitle")]
    #[doc(alias = "subtitle")]
    fn set_subtitle(&self, subtitle: Option<&str>) {
        unsafe {
            ffi::adw_sidebar_item_set_subtitle(
                self.as_ref().to_glib_none().0,
                subtitle.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_suffix")]
    #[doc(alias = "suffix")]
    fn set_suffix(&self, suffix: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_sidebar_item_set_suffix(
                self.as_ref().to_glib_none().0,
                suffix.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_title")]
    #[doc(alias = "title")]
    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::adw_sidebar_item_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_sidebar_item_set_tooltip")]
    #[doc(alias = "tooltip")]
    fn set_tooltip(&self, tooltip: Option<&str>) {
        unsafe {
            ffi::adw_sidebar_item_set_tooltip(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_use_underline")]
    #[doc(alias = "use-underline")]
    fn set_use_underline(&self, use_underline: bool) {
        unsafe {
            ffi::adw_sidebar_item_set_use_underline(
                self.as_ref().to_glib_none().0,
                use_underline.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_sidebar_item_set_visible")]
    #[doc(alias = "visible")]
    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::adw_sidebar_item_set_visible(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "drag-motion-activate")]
    fn connect_drag_motion_activate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_drag_motion_activate_trampoline<
            P: IsA<SidebarItem>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::drag-motion-activate".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_drag_motion_activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "enabled")]
    fn connect_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enabled_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::enabled".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enabled_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<
            P: IsA<SidebarItem>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::icon-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "icon-paintable")]
    fn connect_icon_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_paintable_trampoline<
            P: IsA<SidebarItem>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::icon-paintable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_icon_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "section")]
    fn connect_section_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_section_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::section".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_section_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "subtitle")]
    fn connect_subtitle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtitle_trampoline<
            P: IsA<SidebarItem>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtitle".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtitle_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "suffix")]
    fn connect_suffix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_suffix_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::suffix".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_suffix_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::title".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "tooltip")]
    fn connect_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tooltip".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "use-underline")]
    fn connect_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_underline_trampoline<
            P: IsA<SidebarItem>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::use-underline".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_use_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "visible")]
    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<P: IsA<SidebarItem>, F: Fn(&P) + 'static>(
            this: *mut ffi::AdwSidebarItem,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SidebarItem::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<SidebarItem>> SidebarItemExt for O {}
