#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#	Copyright 2013, Marten de Vries
#
#	This file is part of Code of Conduct Signing Assistant.
#
#	Code of Conduct Signing Assistant is free software: you can
#	redistribute it and/or modify it under the terms of the GNU General
#	Public License as published by the Free Software Foundation, either
#	version 3 of the License, or (at your option) any later version.
#
#	Code of Conduct Signing Assistant is distributed in the hope that it
#	will be useful, but WITHOUT ANY WARRANTY; without even the implied
#	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#	See the GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with Code of Conduct Signing Assistant. If not, see
#	<http://www.gnu.org/licenses/>.

#Do prior to running this script (only needs to be done once.)
#
#Step 1: Install pbuilder with sudo apt-get install pbuilder
#
#Step 2: Edit ~/.pbuilderrc and add:
#
#COMPONENTS="main universe multiverse restricted"
#
#Step 3: sudo pbuilder create 

import subprocess
import tempfile
import shutil
import glob
import os

working_dir = tempfile.mkdtemp()
subprocess.check_call([
	"bzr",
	"dailydeb",
	"--allow-fallback-to-native",
	"code-of-conduct-signing-assistant.recipe",
	working_dir,
])

dscPath = glob.glob(os.path.join(working_dir, "*.dsc"))[0]
subprocess.check_call(["sudo", "pbuilder", "build", dscPath])
#the one with the highest version number
debPath = sorted(glob.glob("/var/cache/pbuilder/result/code-of-conduct-signing-assistant*.deb"))[-1]
shutil.copy(debPath, ".")

shutil.rmtree(working_dir)
