Terminology
-----------

The main terminology used in malcontent is ‘parental controls’, which are
implemented by ‘administrators’ and enforced on ‘child users’.

The feature applies to a range of other carer/caree relationships, though, where
the ‘caree’ user might need to be protected from doing things on the computer
which aren’t suitable for them.

The terminology ‘parental controls’ is used consistently, despite not all
situations actually involving a parent or child, because that’s how most users
will find the functionality.

To remain as inclusive as possible, there are some rules about which terminology
to use:
 - Use ‘parental controls’ to refer to the overall feature
 - Refer to ‘administrators’ or ‘administrator accounts’ rather than ‘parents’
 - Refer to ‘child users’ in general contexts, but refer to particular user
   accounts using their full name — don’t mention ‘child’ in that case

A ‘family groups’ concept has
[been proposed](https://gitlab.gnome.org/Teams/Design/app-mockups/-/issues/118)
which would add the possibility for parental controls to be managed by users
other than system administrator accounts. While ‘administrators’ or
‘administrator accounts’ will continue to be used in the UI for now, internally
the code should refer to any of these users as ‘parents’ to prevent confusion
between system administrators (i.e. users who are in the `wheel` group) and
administrators of the family group.

References:
 * https://gitlab.freedesktop.org/pwithnall/malcontent/-/issues/13
 * https://gitlab.gnome.org/Teams/Design/app-mockups/-/issues/118
