/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QObject>
#include <QAction>
#include <QSettings>
#include <QStyleOptionViewItem>
#include <QStyledItemDelegate>
#include <QModelIndex>
#include <QTableWidget>
#include <QGroupBox>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"
#include "MsXpS/libXpertMassGui/ActionManager.hpp"

namespace MsXpS
{
namespace libXpertMassGui
{

enum ActionManagerTableWidgetColumns
{
  ContextColumn = 0,
  CategoryColumn,
  UnitColumn,
  ShortcutColumn,
  LabelColumn,
  ColumnCount
};

class DECLSPEC ActionShortcutDelegate final: public QStyledItemDelegate
{
  Q_OBJECT

  public:
  explicit ActionShortcutDelegate(QObject *parent = nullptr);

  QWidget *createEditor(QWidget *parent,
                        const QStyleOptionViewItem &,
                        const QModelIndex &) const override;

  void setEditorData(QWidget *editor, const QModelIndex &index) const override;

  void setModelData(QWidget *editor,
                    QAbstractItemModel *model,
                    const QModelIndex &index) const override;

  void updateEditorGeometry(QWidget *editor,
                            const QStyleOptionViewItem &option,
                            const QModelIndex &index) const override;
};

class ActionManagerTableWidget final: public QWidget
{
  Q_OBJECT

  public:
  explicit ActionManagerTableWidget(QWidget *parent = nullptr);

  void setActionManager(ActionManager *action_manager_p);
  ActionManager *getActionManager();

  int fillInTableWithData();

  void addActionRow(const QString &context,
                    const QString &category,
                    const QString &unit,
                    const QString &label,
                    const QKeySequence &shortcut = {});

  void addActionRow(const ActionId action_id,
                    const QKeySequence &shortcut = {});

  ActionId actionId(const QModelIndex &index);

  void updateShortcut(const ActionId &action_id, const QKeySequence &shortcut);

  private:
  QGroupBox *mp_groupBox;
  ActionManager *mp_actionManager = nullptr;
  QTableWidget *mp_tableWidget;
};


} // namespace libXpertMassGui
} // namespace MsXpS
