% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labeller.R
\name{label_bquote}
\alias{label_bquote}
\title{Label with mathematical expressions}
\usage{
label_bquote(rows = NULL, cols = NULL, default)
}
\arguments{
\item{rows}{Backquoted labelling expression for rows.}

\item{cols}{Backquoted labelling expression for columns.}

\item{default}{Unused, kept for compatibility.}
}
\description{
\code{label_bquote()} offers a flexible way of labelling
facet rows or columns with plotmath expressions. Backquoted
variables will be replaced with their value in the facet.
}
\examples{
# The variables mentioned in the plotmath expression must be
# backquoted and referred to by their names.
p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()
p + facet_grid(vs ~ ., labeller = label_bquote(alpha ^ .(vs)))
p + facet_grid(. ~ vs, labeller = label_bquote(cols = .(vs) ^ .(vs)))
p + facet_grid(. ~ vs + am, labeller = label_bquote(cols = .(am) ^ .(vs)))
}
\seealso{
\link{labellers}, \code{\link[=labeller]{labeller()}},
}
