/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.TransformRestoreEdit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractRotateHandle
extends AbstractHandle {
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public AbstractRotateHandle(Figure figure) {
        super(figure);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    @Override
    public String getToolTipText(Point point) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        return resourceBundleUtil.getString("handle.rotate.toolTipText");
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawCircle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_STROKE_COLOR));
        } else {
            this.drawCircle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        int n = this.getHandlesize();
        rectangle.x -= n / 2;
        rectangle.y -= n / 2;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    protected Rectangle2D.Double getTransformedBounds() {
        Figure figure = this.getOwner();
        Rectangle2D.Double double_ = figure.getBounds();
        if (figure.get(AttributeKeys.TRANSFORM) != null) {
            Rectangle2D rectangle2D = figure.get(AttributeKeys.TRANSFORM).createTransformedShape(double_).getBounds2D();
            double_.x = rectangle2D.getX();
            double_.y = rectangle2D.getY();
            double_.width = rectangle2D.getWidth();
            double_.height = rectangle2D.getHeight();
        }
        return double_;
    }

    protected Object getRestoreData() {
        return this.restoreData;
    }

    protected double getStartTheta() {
        return this.startTheta;
    }

    protected abstract Point2D.Double getOrigin();

    protected abstract Point2D.Double getCenter();

    @Override
    public void trackStart(Point point, int n) {
        this.location = new Point(point.x, point.y);
        this.restoreData = this.getOwner().getTransformRestoreData();
        this.transform = new AffineTransform();
        this.center = this.getCenter();
        Point2D.Double double_ = this.view.viewToDrawing(point);
        this.startTheta = Geom.angle(this.center.x, this.center.y, double_.x, double_.y);
        this.startLength = Geom.length(this.center.x, this.center.y, double_.x, double_.y);
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        this.location = new Point(point2.x, point2.y);
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        double d = Geom.angle(this.center.x, this.center.y, double_.x, double_.y);
        double d2 = Geom.length(this.center.x, this.center.y, double_.x, double_.y);
        double d3 = this.view.getConstrainer().constrainAngle(d - this.startTheta);
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.rotate(d3);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTransformTo(this.restoreData);
        this.getOwner().transform(this.transform);
        this.getOwner().changed();
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        this.view.getDrawing().fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.restoreData, this.getOwner().getTransformRestoreData()));
        this.fireAreaInvalidated(this.getDrawingArea());
        this.location = null;
        this.invalidate();
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Figure figure = this.getOwner();
        this.center = this.getCenter();
        if (figure.isTransformable()) {
            AffineTransform affineTransform = new AffineTransform();
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: {
                    affineTransform.rotate(-Math.PI / 180, this.center.x, this.center.y);
                    keyEvent.consume();
                    break;
                }
                case 39: 
                case 40: {
                    affineTransform.rotate(Math.PI / 180, this.center.x, this.center.y);
                    keyEvent.consume();
                }
            }
            figure.willChange();
            figure.transform(affineTransform);
            figure.changed();
            this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
        }
    }
}

