#include <SDL/SDL.h>
#include "isola.h"

// ****************************************************************************
// ********************************** Alea ************************************
// ****************************************************************************
int Alea (short min, short max)
{
	return (unsigned short)rand() * (max - min) / 65536 + min;
}


// ****************************************************************************
// ****************************** ImageErreur *********************************
// ****************************************************************************
void ImageErreur (char *image)
{
	// Affiche un message d'erreur et quitte le programme
	fprintf (stderr, "Impossible de charger l'image %s (%s)\n", image, SDL_GetError ());
	exit (1);
}


// ****************************************************************************
// ****************************** Case2Coord **********************************
// ****************************************************************************
int Case2CoordX (int x, GRILLE grille)
{
	// Renvoit l'abscisse cran du coin haut gauche de la case
	return grille.x1 + x * grille.tc;
}

int Case2CoordY (int y, GRILLE grille)
{
	// Renvoit l'abscisse cran du coin haut gauche de la case
	return grille.y1 + y * grille.tc;
}


// ****************************************************************************
// ****************************** Clic2Case ***********************************
// ****************************************************************************
int Clic2CaseX (int x, GRILLE grille)
{
	// Renvoit l'abscisse de la case clique ou -1 si en dehors de la grille
	if (x >= grille.x1 && x < grille.x2)
		return (x - grille.x1 - 1) / grille.tc;
	else
		return -1;
}

int Clic2CaseY (int y, GRILLE grille)
{
	// Renvoit l'ordonne de la case clique ou -1 si en dehors de la grille
	if (y >= grille.y1 && y <= grille.y2)
		return (y - grille.y1 - 1) / grille.tc;
	else
		return -1;
}


// ****************************************************************************
// ******************************* Attendre_FPS *******************************
// ****************************************************************************
void Attendre_FPS (void)
{
	static int temps = 0;				// Moment du dernier appel de cette fonction
	
	// Marque une pause pour synchroniser l'affichage sur la vitesse choisie pour que
	// le temps entre 2 appels de cette fonction soit de: 1000 ms / Frames Par Seconde
	while (SDL_GetTicks() < temps + 1000 / FPS);
	
	temps = SDL_GetTicks ();			// Moment o cette fonction se termine
}


// ****************************************************************************
// ********************************* Dans_Rect ********************************
// ****************************************************************************
BOOL Dans_Rect (int x, int y, SDL_Rect rect)
{
	if (x >= rect.x && x <= (rect.x + rect.w) && y >= rect.y && y <= (rect.y + rect.h))
		return OUI;
	else
		return NON;
}


// ****************************************************************************
// ************************** Afficher_Caractere ******************************
// ****************************************************************************
void Afficher_Caractere (int x, int y, char c, POLICE police, SDL_Surface *ecran)
{
	SDL_Rect dest;

	// Place le rectangle sur la bonne image du caractre  afficher
	if (c >= 'A' && c <= 'Z') police.rect.x = (c - 'A') * police.rect.w;
	else if (c >= 'a' && c <= 'z') police.rect.x = (c - 'a') * police.rect.w;
	else if (c >= '0' && c <= '9') police.rect.x = (c - '0' + 26) * police.rect.w;
	else if (c == ':') police.rect.x = 36 * police.rect.w;
	else return;

	// Position sur l'cran
	dest.x = x;
	dest.y = y;
	dest.w = police.rect.w;
	dest.h = police.rect.h;

	// Copie le caractre et met  jour
	SDL_BlitSurface (police.img, &police.rect, ecran, &dest);
	SDL_UpdateRects (ecran, 1, &dest);
}


// ****************************************************************************
// **************************** Afficher_Chaine *******************************
// ****************************************************************************
BOOL Afficher_Chaine (int x, int y, int vitesse, char chaine[], POLICE police, SDL_Surface *ecran, SDL_Surface *back)
{
	SDL_Rect dest = {0, 0, police.rect.w, police.rect.h};
	SDL_Event evt;
	int xDep, yDep, xDest, yDest;
	int c;
	int frame;

	// Parcours la chaine de caractre et affiche les caractres un par un en
	// les faisant glisser de l'un des bord de l'cran
	for (c = 0; chaine[c] != '\0'; c ++)
	{
		// Choisit alatoirement le bord de l'cran et sa position dessus
		switch (Alea (0, 2))
		{
			case 0:	xDep = Alea (0, ecran->w - police.rect.w);
					yDep = Alea (0, 2) ? 0 : ecran->h - police.rect.h;
					break;
			case 1:	xDep = Alea (0, 2) ? 0 : ecran->w - police.rect.w;
					yDep = Alea (0, ecran->h - police.rect.h);
					break;
			default:	xDep = yDep = 0;
		}
		
		xDest = x + c * police.rect.w;
		yDest = y;
		
		// Fait glisser le caractre du bord de l'cran vers sa position finale
		if (vitesse > 0)
		for (frame = 0; frame <= vitesse; frame ++)
		{
			// Quitte sur un appui sur la touche [ESC]
			if (SDL_PollEvent (&evt) && evt.type == SDL_KEYDOWN && evt.key.keysym.sym == SDLK_ESCAPE) return OUI;
		
			// Efface l'ancienne position
			SDL_BlitSurface (back, &dest, ecran, &dest);
			
			// Affiche le caractre au bon endroit
			Afficher_Caractere (xDep + ((xDest - xDep) * frame) / vitesse, yDep + ((yDest - yDep) * frame) / vitesse, chaine[c], police, ecran);
			SDL_UpdateRects (ecran, 1, &dest);
			
			// Fait la moyenne pour savoir o doit tre affich le caractre
			dest.x = xDep + ((xDest - xDep) * frame) / vitesse;
			dest.y = yDep + ((yDest - yDep) * frame) / vitesse;
			Attendre_FPS ();
		}

		// Affiche le caractre  sa position finale
		Afficher_Caractere (xDest, yDest, chaine[c], police, ecran);
		Afficher_Caractere (xDest, yDest, chaine[c], police, back);
	}
	
	return NON;
}


// ****************************************************************************
// ******************************* Questionner ********************************
// ****************************************************************************
BOOL Questionner (char ch[], POLICE police1, POLICE police2, POLICE police3, SDL_Surface *ecran)
{
	SDL_Surface *save, *noire;
	SDL_Event evt;
	SDL_Rect box;			// Rect de copie de la "boite de dialogue"
	SDL_Rect oui, non;		// Rects de cliquage des boutons OUI et NON
	
	// Rect de la boite de dialogue du message
	box.w = police1.rect.w * (strlen (ch) + 3);
	box.h = police1.rect.h * 5;
	box.x = (ecran->w - box.w) / 2;
	box.y = (ecran->h - box.h) / 2 + police1.rect.h / 3;
	
	// Cre une surface pour sauvegarder la partie de l'cran qui sera recouverte par le message
	save = SDL_CreateRGBSurface (SDL_SWSURFACE, box.w, box.h, 32, 0, 0, 0, 0);
	SDL_BlitSurface (ecran, &box, save, NULL);
	
	// Cre une surface noire semi-transparente qui servira  assombrir une partie de l'cran
	if (!(noire = SDL_DisplayFormat (save)))
	{ 	fprintf (stderr, "Impossible de crer un back buffer (%s)\n", SDL_GetError ());
		SDL_FreeSurface (save);
		SDL_FreeSurface (noire);
		exit (1);
	}
	SDL_FillRect (noire, NULL, SDL_MapRGB (noire->format, 0, 0, 0));
	SDL_SetAlpha (noire, SDL_SRCALPHA, 128);
	
	// Assombrit l'cran et met  jour
	SDL_BlitSurface (noire, NULL, ecran, &box);
	SDL_UpdateRects (ecran, 1, &box);
	SDL_FreeSurface (noire);
	
	// Rects des boutons OUI et NON
	oui.w = strlen (TXT_OUI) * police3.rect.w;
	oui.h = police3.rect.h;
	oui.x = ecran->w / 2 + police3.rect.w;
	oui.y = ecran->h / 2 + police3.rect.h;
	
	non.w = strlen (TXT_NON) * police2.rect.w;
	non.h = police2.rect.h;
	non.x = ecran->w / 2 - non.w - police2.rect.w;
	non.y = ecran->h / 2 + police2.rect.h;
	
	// Affiche le texte de la question et les textes des boutons OUI et NON
	Afficher_Chaine ((ecran->w - strlen (ch) * police1.rect.w) / 2, ecran->h / 2 - police1.rect.h, 0, ch, police1, ecran, ecran);
	Afficher_Chaine (oui.x, oui.y, 0, TXT_OUI, police3, ecran, ecran);
	Afficher_Chaine (non.x, non.y, 0, TXT_NON, police2, ecran, ecran);
	
	while (1)
	if (SDL_PollEvent (&evt))
	{	
		// Anulle sur un appui de la touche [ESC], ou un clic sur NON
		if ((evt.type == SDL_KEYDOWN && evt.key.keysym.sym == SDLK_ESCAPE) || (evt.type == SDL_MOUSEBUTTONDOWN && evt.button.button == 1 && Dans_Rect (evt.button.x, evt.button.y, non)))
		{	SDL_BlitSurface (save, NULL, ecran, &box);
			SDL_UpdateRects (ecran, 1, &box);
			SDL_FreeSurface (save);
			return NON;
		}
		
		// Retourne OUI  la fonction ayant pos cette question
		if (evt.type == SDL_MOUSEBUTTONDOWN && evt.button.button == 1 && Dans_Rect (evt.button.x, evt.button.y, oui))
		{	SDL_BlitSurface (save, NULL, ecran, &box);
			SDL_UpdateRects (ecran, 1, &box);
			SDL_FreeSurface (save);
			return OUI;
		}
	}
}


// ****************************************************************************
// ******************************** Informer **********************************
// ****************************************************************************
BOOL Informer (char ch[], POLICE police, SDL_Surface *ecran)
{
	SDL_Rect box;			// Rect de copie de la "boite de dialogue"
	SDL_Surface *noire;
	
	// Rect de la boite de dialogue du message
	box.w = police.rect.w * (strlen (ch) + 3);
	box.h = police.rect.h * 3;
	box.x = (ecran->w - box.w) / 2;
	box.y = (ecran->h - box.h) / 2;
	
	// Cre une surface noire semi-transparente qui servira  assombrir une partie de l'cran
	if (!(noire = SDL_CreateRGBSurface (SDL_SWSURFACE, box.w, box.h, 32, 0, 0, 0, 0)))
	{ 	fprintf (stderr, "Impossible de crer une surface (%s)\n", SDL_GetError ());
		SDL_FreeSurface (noire);
		exit (1);
	}
	SDL_FillRect (noire, NULL, SDL_MapRGB (noire->format, 0, 0, 0));
	SDL_SetAlpha (noire, SDL_SRCALPHA, 128);
	
	// Assombrit l'cran et met  jour
	SDL_BlitSurface (noire, NULL, ecran, &box);
	SDL_UpdateRects (ecran, 1, &box);
	SDL_FreeSurface (noire);
	
	// Affiche le texte de la question et les textes des boutons OUI et NON
	Afficher_Chaine ((ecran->w - strlen (ch) * police.rect.w) / 2, (ecran->h - police.rect.h) / 2, 0, ch, police, ecran, ecran);
}