#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Voice browser: next module"

    def run(self):
        if "voiceBrowserInstance" in self.env["runtime"]:
            self.env["runtime"]["voiceBrowserInstance"].next_module()

    def set_callback(self, callback):
        pass
