# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dashboard import DashboardManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDashboardManagementManagedPrivateEndpointsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DashboardManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_begin_refresh(self, resource_group):
        response = self.client.managed_private_endpoints.begin_refresh(
            resource_group_name=resource_group.name,
            workspace_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_get(self, resource_group):
        response = self.client.managed_private_endpoints.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            managed_private_endpoint_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_begin_create(self, resource_group):
        response = self.client.managed_private_endpoints.begin_create(
            resource_group_name=resource_group.name,
            workspace_name="str",
            managed_private_endpoint_name="str",
            request_body_parameters={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "connectionState": {"description": "str", "status": "str"},
                    "groupIds": ["str"],
                    "privateLinkResourceId": "str",
                    "privateLinkResourceRegion": "str",
                    "privateLinkServicePrivateIP": "str",
                    "privateLinkServiceUrl": "str",
                    "provisioningState": "str",
                    "requestMessage": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_begin_update(self, resource_group):
        response = self.client.managed_private_endpoints.begin_update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            managed_private_endpoint_name="str",
            request_body_parameters={"tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_begin_delete(self, resource_group):
        response = self.client.managed_private_endpoints.begin_delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
            managed_private_endpoint_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_list(self, resource_group):
        response = self.client.managed_private_endpoints.list(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
