# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AnnotationDTO(_model_base.Model):
    """AnnotationDTO.

    All required parameters must be populated in order to send to server.

    :ivar annotation_task: Required.
    :vartype annotation_task: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar user_text_list: Required.
    :vartype user_text_list: list[str]
    :ivar contents: Required.
    :vartype contents: list[~raiclient.models.Content]
    :ivar metric_list: Required.
    :vartype metric_list: list[str]
    :ivar prompt_version: Required.
    :vartype prompt_version: str
    """

    annotation_task: str = rest_field(name="AnnotationTask", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_type: str = rest_field(name="ContentType", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    user_text_list: List[str] = rest_field(
        name="UserTextList", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    contents: List["_models.Content"] = rest_field(
        name="Contents", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    metric_list: List[str] = rest_field(name="MetricList", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    prompt_version: str = rest_field(name="PromptVersion", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        annotation_task: str,
        content_type: str,
        user_text_list: List[str],
        contents: List["_models.Content"],
        metric_list: List[str],
        prompt_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Content(_model_base.Model):
    """Content.

    All required parameters must be populated in order to send to server.

    :ivar messages: Required.
    :vartype messages: list[any]
    """

    messages: List[Any] = rest_field(name="Messages", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        messages: List[Any],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomizationParameters(_model_base.Model):
    """Customization Parameters.

    All required parameters must be populated in order to send to server.

    :ivar application_scenario: Application scenario.
    :vartype application_scenario: str
    :ivar harm_categories: List of harm categories. Required.
    :vartype harm_categories: list[str]
    """

    application_scenario: Optional[str] = rest_field(
        name="ApplicationScenario", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application scenario."""
    harm_categories: List[str] = rest_field(
        name="HarmCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of harm categories. Required."""

    @overload
    def __init__(
        self,
        *,
        harm_categories: List[str],
        application_scenario: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Data(_model_base.Model):
    """Data.

    All required parameters must be populated in order to send to server.

    :ivar asset_id: Required.
    :vartype asset_id: str
    """

    asset_id: str = rest_field(name="assetId", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        asset_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Grader(_model_base.Model):
    """Grader.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar config: Required.
    :vartype config: ~raiclient.models.GraderConfigBase
    """

    name: str = rest_field(name="Name", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    description: str = rest_field(name="Description", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    config: "_models.GraderConfigBase" = rest_field(
        name="Config", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: str,
        config: "_models.GraderConfigBase",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GraderConfigBase(_model_base.Model):
    """GraderConfigBase.

    All required parameters must be populated in order to send to server.

    :ivar type: Required.
    :vartype type: str
    """

    type: str = rest_field(name="Type", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GradersDTO(_model_base.Model):
    """GradersDTO.

    All required parameters must be populated in order to send to server.

    :ivar data: Required.
    :vartype data: ~raiclient.models.Data
    :ivar model_config: Required.
    :vartype model_config: ~raiclient.models.ModelConfig
    :ivar sample_generators: Required.
    :vartype sample_generators: list[~raiclient.models.SampleGenerator]
    :ivar graders: Required.
    :vartype graders: list[~raiclient.models.Grader]
    """

    data: "_models.Data" = rest_field(name="Data", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    model_config: "_models.ModelConfig" = rest_field(
        name="ModelConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    sample_generators: List["_models.SampleGenerator"] = rest_field(
        name="SampleGenerators", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    graders: List["_models.Grader"] = rest_field(
        name="Graders", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        data: "_models.Data",
        model_config: "_models.ModelConfig",
        sample_generators: List["_models.SampleGenerator"],
        graders: List["_models.Grader"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LongRunningResponse(_model_base.Model):
    """LongRunningResponse.


    :ivar location: Required.
    :vartype location: str
    :ivar operation_result: Required.
    :vartype operation_result: any
    """

    location: str = rest_field(name="Location", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    operation_result: Any = rest_field(
        name="OperationResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        operation_result: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ModelConfig(_model_base.Model):
    """ModelConfig.

    All required parameters must be populated in order to send to server.

    :ivar azure_endpoint: Required.
    :vartype azure_endpoint: str
    """

    azure_endpoint: str = rest_field(name="AzureEndpoint", visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        azure_endpoint: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SampleGenerator(_model_base.Model):
    """SampleGenerator.

    All required parameters must be populated in order to send to server.

    :ivar model_name: Required.
    :vartype model_name: str
    :ivar type: Required.
    :vartype type: str
    :ivar sampling_params: Required.
    :vartype sampling_params: any
    :ivar trajectory_template: Required.
    :vartype trajectory_template: any
    """

    model_name: str = rest_field(name="ModelName", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    type: str = rest_field(name="Type", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    sampling_params: Any = rest_field(name="SamplingParams", visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    trajectory_template: Any = rest_field(
        name="TrajectoryTemplate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        model_name: str,
        type: str,
        sampling_params: Any,
        trajectory_template: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SimulationDTO(_model_base.Model):
    """Customization Parameters.

    :ivar headers: Additional headers.
    :vartype headers: dict[str, str]
    :ivar params: Parameters.
    :vartype params: dict[str, str]
    :ivar template_parameters: Template parameters.
    :vartype template_parameters: dict[str, str]
    :ivar customization_parameters: Customization parameters.
    :vartype customization_parameters: ~raiclient.models.CustomizationParameters
    :ivar json: Json.
    :vartype json: str
    :ivar url: Url.
    :vartype url: str
    :ivar template_key: Template key.
    :vartype template_key: str
    :ivar simulation_type: Type of Simulation. Known values are: "Default", "CustomPersona", and
     "HarmTurnGenerator".
    :vartype simulation_type: str or ~raiclient.models.SimulationType
    :ivar is_microsoft_tenant: 'True' if Microsoft internal tenant and 'False' otherwise.
    :vartype is_microsoft_tenant: bool
    :ivar subscription_id: Azure subscription id.
    :vartype subscription_id: str
    :ivar resource_group_name: Resource group name.
    :vartype resource_group_name: str
    :ivar workspace_name: Workspace name.
    :vartype workspace_name: str
    """

    headers: Optional[Dict[str, str]] = rest_field(
        name="Headers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional headers."""
    params: Optional[Dict[str, str]] = rest_field(
        name="Params", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters."""
    template_parameters: Optional[Dict[str, str]] = rest_field(
        name="TemplateParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Template parameters."""
    customization_parameters: Optional["_models.CustomizationParameters"] = rest_field(
        name="CustomizationParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customization parameters."""
    json: Optional[str] = rest_field(name="Json", visibility=["read", "create", "update", "delete", "query"])
    """Json."""
    url: Optional[str] = rest_field(name="Url", visibility=["read", "create", "update", "delete", "query"])
    """Url."""
    template_key: Optional[str] = rest_field(
        name="TemplateKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Template key."""
    simulation_type: Optional[Union[str, "_models.SimulationType"]] = rest_field(
        name="SimulationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Simulation. Known values are: \"Default\", \"CustomPersona\", and
     \"HarmTurnGenerator\"."""
    is_microsoft_tenant: Optional[bool] = rest_field(
        name="IsMicrosoftTenant", visibility=["read", "create", "update", "delete", "query"]
    )
    """'True' if Microsoft internal tenant and 'False' otherwise."""
    subscription_id: Optional[str] = rest_field(
        name="SubscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure subscription id."""
    resource_group_name: Optional[str] = rest_field(
        name="ResourceGroupName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource group name."""
    workspace_name: Optional[str] = rest_field(
        name="WorkspaceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Workspace name."""

    @overload
    def __init__(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        params: Optional[Dict[str, str]] = None,
        template_parameters: Optional[Dict[str, str]] = None,
        customization_parameters: Optional["_models.CustomizationParameters"] = None,
        json: Optional[str] = None,
        url: Optional[str] = None,
        template_key: Optional[str] = None,
        simulation_type: Optional[Union[str, "_models.SimulationType"]] = None,
        is_microsoft_tenant: Optional[bool] = None,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        workspace_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
