# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementDataCollectionRuleAssociationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_list_by_resource(self, resource_group):
        response = self.client.data_collection_rule_associations.list_by_resource(
            resource_uri="str",
            api_version="2023-03-11",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_list_by_rule(self, resource_group):
        response = self.client.data_collection_rule_associations.list_by_rule(
            resource_group_name=resource_group.name,
            data_collection_rule_name="str",
            api_version="2023-03-11",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_list_by_data_collection_endpoint(self, resource_group):
        response = self.client.data_collection_rule_associations.list_by_data_collection_endpoint(
            resource_group_name=resource_group.name,
            data_collection_endpoint_name="str",
            api_version="2023-03-11",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_get(self, resource_group):
        response = await self.client.data_collection_rule_associations.get(
            resource_uri="str",
            association_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_create(self, resource_group):
        response = await self.client.data_collection_rule_associations.create(
            resource_uri="str",
            association_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_collection_rule_associations_delete(self, resource_group):
        response = await self.client.data_collection_rule_associations.delete(
            resource_uri="str",
            association_name="str",
            api_version="2023-03-11",
        )

        # please add some check logic here by yourself
        # ...
