% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_seq}
\alias{date_seq}
\title{Sequences: date and date-time}
\usage{
date_seq(from, ..., to = NULL, by = NULL, total_size = NULL)
}
\arguments{
\item{from}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1)]}

A date or date-time to start the sequence from.}

\item{...}{These dots are for future extensions and must be empty.}

\item{to}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

A date or date-time to stop the sequence at.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.}

\item{total_size}{\verb{[positive integer(1) / NULL]}

The size of the resulting sequence.

If specified alongside \code{to}, this must generate a non-fractional sequence
between \code{from} and \code{to}.}
}
\value{
A date or date-time vector.
}
\description{
\code{date_seq()} generates a date (Date) or date-time (POSIXct/POSIXlt) sequence.

There are separate help pages for generating sequences for dates and
date-times:
\itemize{
\item \link[=date-sequence]{dates (Date)}
\item \link[=posixt-sequence]{date-times (POSIXct/POSIXlt)}
}
}
\examples{
# See method specific documentation for more examples

x <- as.Date("2019-01-01")
date_seq(x, by = duration_months(2), total_size = 20)
}
