/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.BitArray;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;
import org.openhab.core.io.transport.modbus.ModbusWriteCoilRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteFunctionCode;
import org.openhab.core.io.transport.modbus.ModbusWriteRegisterRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprint;

@NonNullByDefault
public final class WriteRequestJsonUtilities {
    public static final String JSON_FUNCTION_CODE = "functionCode";
    public static final String JSON_ADDRESS = "address";
    public static final String JSON_VALUE = "value";
    public static final String JSON_MAX_TRIES = "maxTries";
    public static final int DEFAULT_MAX_TRIES = 3;

    private WriteRequestJsonUtilities() {
        throw new UnsupportedOperationException();
    }

    public static Collection<ModbusWriteRequestBlueprint> fromJson(int unitId, String jsonString) {
        JsonArray jsonArray = JsonParser.parseString((String)jsonString).getAsJsonArray();
        if (jsonArray.isEmpty()) {
            return new LinkedList<ModbusWriteRequestBlueprint>();
        }
        LinkedList<ModbusWriteRequestBlueprint> writes = new LinkedList<ModbusWriteRequestBlueprint>();
        jsonArray.forEach(writeElem -> writes.add(WriteRequestJsonUtilities.constructBluerint(unitId, writeElem)));
        return writes;
    }

    private static ModbusWriteRequestBlueprint constructBluerint(int unitId, JsonElement arrayElement) {
        JsonArray valuesElem;
        JsonObject writeObject;
        try {
            writeObject = arrayElement.getAsJsonObject();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("JSON array contained something else than a JSON object!", e);
        }
        @Nullable JsonElement functionCode = writeObject.get(JSON_FUNCTION_CODE);
        @Nullable JsonElement address = writeObject.get(JSON_ADDRESS);
        @Nullable JsonElement maxTries = writeObject.get(JSON_MAX_TRIES);
        try {
            valuesElem = writeObject.get(JSON_VALUE).getAsJsonArray();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format("JSON object '%s' is not an JSON array!", JSON_VALUE), e);
        }
        return WriteRequestJsonUtilities.constructBluerint(unitId, functionCode, address, maxTries, valuesElem);
    }

    private static ModbusWriteRequestBlueprint constructBluerint(int unitId, @Nullable JsonElement functionCodeElem, @Nullable JsonElement addressElem, @Nullable JsonElement maxTriesElem, @Nullable JsonArray valuesElem) {
        int maxTries;
        int address;
        int functionCodeNumeric;
        if (functionCodeElem == null || functionCodeElem.isJsonNull()) {
            throw new IllegalStateException(String.format("Value for '%s' is invalid", JSON_FUNCTION_CODE));
        }
        try {
            functionCodeNumeric = functionCodeElem.getAsInt();
        }
        catch (ClassCastException | IllegalStateException e) {
            throw new IllegalStateException(String.format("Value for '%s' is invalid", JSON_FUNCTION_CODE), e);
        }
        ModbusWriteFunctionCode functionCode = ModbusWriteFunctionCode.fromFunctionCode(functionCodeNumeric);
        if (addressElem == null || addressElem.isJsonNull()) {
            throw new IllegalStateException(String.format("Value for '%s' is invalid", JSON_ADDRESS));
        }
        try {
            address = addressElem.getAsInt();
        }
        catch (ClassCastException | IllegalStateException e) {
            throw new IllegalStateException(String.format("Value for '%s' is invalid", JSON_ADDRESS), e);
        }
        if (maxTriesElem == null || maxTriesElem.isJsonNull()) {
            maxTries = 3;
        } else {
            try {
                maxTries = maxTriesElem.getAsInt();
            }
            catch (ClassCastException | IllegalStateException e) {
                throw new IllegalStateException(String.format("Value for '%s' is invalid", JSON_MAX_TRIES), e);
            }
        }
        if (valuesElem == null || valuesElem.isJsonNull()) {
            throw new IllegalArgumentException(String.format("Expecting non-null value, got: %s", valuesElem));
        }
        AtomicBoolean writeSingle = new AtomicBoolean(false);
        switch (functionCode) {
            case WRITE_COIL: {
                writeSingle.set(true);
                if (valuesElem.size() != 1) {
                    throw new IllegalArgumentException(String.format("Expecting single value with functionCode=%s, got: %s", new Object[]{functionCode, valuesElem}));
                }
            }
            case WRITE_MULTIPLE_COILS: {
                if (valuesElem.isEmpty()) {
                    throw new IllegalArgumentException("Must provide at least one coil");
                }
                if (valuesElem.size() > 1968) {
                    throw new IllegalArgumentException(String.format("Trying to write too many coils (%d). Maximum is %s", valuesElem.size(), 1968));
                }
                BitArray bits = new BitArray(valuesElem.size());
                int i = 0;
                while (i < valuesElem.size()) {
                    bits.setBit(i, valuesElem.get(i).getAsInt() != 0);
                    ++i;
                }
                return new ModbusWriteCoilRequestBlueprint(unitId, address, bits, !writeSingle.get(), maxTries);
            }
            case WRITE_SINGLE_REGISTER: {
                writeSingle.set(true);
                if (valuesElem.size() != 1) {
                    throw new IllegalArgumentException(String.format("Expecting single value with functionCode=%s, got: %s", new Object[]{functionCode, valuesElem}));
                }
            }
            case WRITE_MULTIPLE_REGISTERS: {
                int[] registers = new int[valuesElem.size()];
                if (registers.length == 0) {
                    throw new IllegalArgumentException("Must provide at least one register");
                }
                if (valuesElem.size() > 123) {
                    throw new IllegalArgumentException(String.format("Trying to write too many registers (%d). Maximum is %s", valuesElem.size(), 123));
                }
                int i = 0;
                while (i < valuesElem.size()) {
                    registers[i] = valuesElem.get(i).getAsInt();
                    ++i;
                }
                return new ModbusWriteRegisterRequestBlueprint(unitId, address, new ModbusRegisterArray(registers), !writeSingle.get(), maxTries);
            }
        }
        throw new IllegalArgumentException("Unknown function code");
    }
}

