/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.events;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;

@NonNullByDefault
public class TopicEventFilter
implements EventFilter {
    private final @Nullable Pattern topicRegex;
    private final List<Pattern> topicsRegexes = new ArrayList<Pattern>();

    public TopicEventFilter(String topicRegex) {
        this.topicRegex = Pattern.compile(topicRegex);
    }

    public TopicEventFilter(List<String> topicsRegexes) {
        this.topicRegex = null;
        for (String topicRegex : topicsRegexes) {
            this.topicsRegexes.add(Pattern.compile(topicRegex));
        }
    }

    @Override
    public boolean apply(Event event) {
        String topic = event.getTopic();
        Pattern topicRegex = this.topicRegex;
        if (topicRegex != null) {
            return topicRegex.matcher(topic).matches();
        }
        return this.topicsRegexes.stream().anyMatch(p -> p.matcher(topic).matches());
    }
}

