/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.encoding;

import com.google.cloud.firestore.DocumentReference;

class DeserializeContext {
    final ErrorPath errorPath;
    final DocumentReference documentRef;

    DeserializeContext newInstanceWithErrorPath(ErrorPath newPath) {
        return new DeserializeContext(newPath, this.documentRef);
    }

    DeserializeContext(ErrorPath path, DocumentReference docRef) {
        this.errorPath = path;
        this.documentRef = docRef;
    }

    static class ErrorPath {
        static final ErrorPath EMPTY = new ErrorPath(null, null, 0);
        private final int length;
        private final ErrorPath parent;
        private final String name;

        ErrorPath child(String name) {
            return new ErrorPath(this, name, this.length + 1);
        }

        public String toString() {
            if (this.length == 0) {
                return "";
            }
            if (this.length == 1) {
                return this.name;
            }
            return this.parent.toString() + "." + this.name;
        }

        ErrorPath(ErrorPath parent, String name, int length) {
            this.parent = parent;
            this.name = name;
            this.length = length;
        }

        int getLength() {
            return this.length;
        }

        IllegalArgumentException serializeError(String reason) {
            reason = "Could not serialize object. " + reason;
            if (this.getLength() > 0) {
                reason = reason + " (found in field '" + this.toString() + "')";
            }
            return new IllegalArgumentException(reason);
        }

        RuntimeException deserializeError(String reason) {
            reason = "Could not deserialize object. " + reason;
            if (this.getLength() > 0) {
                reason = reason + " (found in field '" + this.toString() + "')";
            }
            return new RuntimeException(reason);
        }
    }
}

