/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.encoding;

import com.google.cloud.firestore.annotation.DocumentId;
import com.google.cloud.firestore.annotation.Exclude;
import com.google.cloud.firestore.annotation.ServerTimestamp;
import com.google.cloud.firestore.encoding.BeanMapper;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.encoding.DeserializeContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

class PojoBeanMapper<T>
extends BeanMapper<T> {
    private static final Logger LOGGER = Logger.getLogger(PojoBeanMapper.class.getName());
    private final Constructor<T> constructor;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Method> getters;
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Field> fields;

    /*
     * WARNING - void declaration
     */
    PojoBeanMapper(Class<T> clazz) {
        super(clazz);
        Constructor<T> constructor;
        this.getters = new HashMap<String, Method>();
        this.fields = new HashMap<String, Field>();
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        this.constructor = constructor;
        for (Method method : clazz.getMethods()) {
            if (!this.shouldIncludeGetter(method)) continue;
            String string = this.propertyName(method);
            this.addProperty(string);
            method.setAccessible(true);
            if (this.getters.containsKey(string)) {
                throw new RuntimeException("Found conflicting getters for name " + method.getName() + " on class " + clazz.getName());
            }
            this.getters.put(string, method);
            this.applyGetterAnnotations(method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (!this.shouldIncludeField((Field)accessibleObject)) continue;
            String string = this.propertyName((Field)accessibleObject);
            this.addProperty(string);
            this.applyFieldAnnotations((Field)accessibleObject);
        }
        Class<T> currentClass = clazz;
        do {
            void var6_14;
            int n;
            Object object = currentClass.getDeclaredMethods();
            int n2 = ((Method[])object).length;
            boolean bl = false;
            while (n < n2) {
                String propertyName2;
                String existingPropertyName;
                Method method = object[n];
                if (this.shouldIncludeSetter(method) && (existingPropertyName = this.properties.get((propertyName2 = this.propertyName(method)).toLowerCase(Locale.US))) != null) {
                    if (!existingPropertyName.equals(propertyName2)) {
                        throw new RuntimeException("Found setter on " + currentClass.getName() + " with invalid case-sensitive name: " + method.getName());
                    }
                    Method existingSetter = this.setters.get(propertyName2);
                    if (existingSetter == null) {
                        method.setAccessible(true);
                        this.setters.put(propertyName2, method);
                        this.applySetterAnnotations(method);
                    } else if (!this.isSetterOverride(method, existingSetter)) {
                        if (currentClass == clazz) {
                            throw new RuntimeException("Class " + clazz.getName() + " has multiple setter overloads with name " + method.getName());
                        }
                        throw new RuntimeException("Found conflicting setters with name: " + method.getName() + " (conflicts with " + existingSetter.getName() + " defined on " + existingSetter.getDeclaringClass().getName() + ")");
                    }
                }
                ++n;
            }
            object = currentClass.getDeclaredFields();
            n2 = ((AccessibleObject[])object).length;
            n = 0;
            while (var6_14 < n2) {
                AccessibleObject accessibleObject = object[var6_14];
                String propertyName = this.propertyName((Field)accessibleObject);
                if (this.properties.containsKey(propertyName.toLowerCase(Locale.US)) && !this.fields.containsKey(propertyName)) {
                    ((Field)accessibleObject).setAccessible(true);
                    this.fields.put(propertyName, (Field)accessibleObject);
                    this.applyFieldAnnotations((Field)accessibleObject);
                }
                ++var6_14;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(Object.class));
        if (this.properties.isEmpty()) {
            throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
        }
        for (String docIdProperty : this.documentIdPropertyNames) {
            if (this.setters.containsKey(docIdProperty) || this.fields.containsKey(docIdProperty)) continue;
            throw new RuntimeException("@DocumentId is annotated on property " + docIdProperty + " of class " + clazz.getName() + " but no field or public setter was found");
        }
    }

    @Override
    Map<String, Object> serialize(T object, DeserializeContext.ErrorPath path) {
        this.verifyValidType(object);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String property : this.properties.values()) {
            Object propertyValue;
            if (this.documentIdPropertyNames.contains(property)) continue;
            if (this.getters.containsKey(property)) {
                Method getter = this.getters.get(property);
                try {
                    propertyValue = getter.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            Field field = this.fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Bean property without field or getter: " + property);
            }
            try {
                propertyValue = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            Object serializedValue = this.getSerializedValue(property, propertyValue, path);
            result.put(property, serializedValue);
        }
        return result;
    }

    @Override
    T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context) {
        T instance;
        if (this.constructor == null) {
            throw context.errorPath.deserializeError("Class " + this.getClazz().getName() + " does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped");
        }
        try {
            instance = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> deserializedProperties = new HashSet<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String propertyName = entry.getKey();
            DeserializeContext.ErrorPath childPath = context.errorPath.child(propertyName);
            if (this.setters.containsKey(propertyName)) {
                Method setter = this.setters.get(propertyName);
                Type[] params = setter.getGenericParameterTypes();
                if (params.length != 1) {
                    throw childPath.deserializeError("Setter does not have exactly one parameter");
                }
                Type resolvedType = this.resolveType(params[0], types);
                Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType, context.newInstanceWithErrorPath(childPath));
                try {
                    setter.invoke(instance, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                deserializedProperties.add(propertyName);
                continue;
            }
            if (this.fields.containsKey(propertyName)) {
                Field field = this.fields.get(propertyName);
                Type resolvedType = this.resolveType(field.getGenericType(), types);
                Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType, context.newInstanceWithErrorPath(childPath));
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                deserializedProperties.add(propertyName);
                continue;
            }
            String message = "No setter/field for " + propertyName + " found on class " + this.getClazz().getName();
            if (this.properties.containsKey(propertyName.toLowerCase(Locale.US))) {
                message = message + " (fields/setters are case sensitive!)";
            }
            if (this.isThrowOnUnknownProperties()) {
                throw new RuntimeException(message);
            }
            if (!this.isWarnOnUnknownProperties()) continue;
            LOGGER.warning(message);
        }
        this.populateDocumentIdProperties(types, context, instance, deserializedProperties);
        return instance;
    }

    private void addProperty(String property) {
        String oldValue = this.properties.put(property.toLowerCase(Locale.US), property);
        if (oldValue != null && !property.equals(oldValue)) {
            throw new RuntimeException("Found two getters or fields with conflicting case sensitivity for property: " + property.toLowerCase(Locale.US));
        }
    }

    private void populateDocumentIdProperties(Map<TypeVariable<Class<T>>, Type> types, DeserializeContext context, T instance, HashSet<String> deserializedProperties) {
        for (String docIdPropertyName : this.documentIdPropertyNames) {
            this.checkForDocIdConflict(docIdPropertyName, deserializedProperties, context);
            DeserializeContext.ErrorPath childPath = context.errorPath.child(docIdPropertyName);
            if (this.setters.containsKey(docIdPropertyName)) {
                Method setter = this.setters.get(docIdPropertyName);
                Type[] params = setter.getGenericParameterTypes();
                if (params.length != 1) {
                    throw childPath.deserializeError("Setter does not have exactly one parameter");
                }
                Type resolvedType = this.resolveType(params[0], types);
                try {
                    if (resolvedType == String.class) {
                        setter.invoke(instance, context.documentRef.getId());
                        continue;
                    }
                    setter.invoke(instance, context.documentRef);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            Field docIdField = this.fields.get(docIdPropertyName);
            try {
                if (docIdField.getType() == String.class) {
                    docIdField.set(instance, context.documentRef.getId());
                    continue;
                }
                docIdField.set(instance, context.documentRef);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void applyGetterAnnotations(Method method) {
        Class<?> returnType = method.getReturnType();
        if (method.isAnnotationPresent(ServerTimestamp.class)) {
            this.validateServerTimestampType("Method", "returns", returnType);
            this.serverTimestamps.add(this.propertyName(method));
        }
        if (method.isAnnotationPresent(DocumentId.class)) {
            this.validateDocumentIdType("Method", "returns", returnType);
            this.documentIdPropertyNames.add(this.propertyName(method));
        }
    }

    private void applySetterAnnotations(Method method) {
        if (method.isAnnotationPresent(ServerTimestamp.class)) {
            throw new IllegalArgumentException("Method " + method.getName() + " is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.");
        }
        if (method.isAnnotationPresent(DocumentId.class)) {
            Class<?> paramType = method.getParameterTypes()[0];
            this.validateDocumentIdType("Method", "accepts", paramType);
            this.documentIdPropertyNames.add(this.propertyName(method));
        }
    }

    private boolean shouldIncludeGetter(Method method) {
        if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !method.isAnnotationPresent(Exclude.class);
    }

    private boolean shouldIncludeSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return !method.isAnnotationPresent(Exclude.class);
    }

    private boolean shouldIncludeField(Field field) {
        if (field.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        return !field.isAnnotationPresent(Exclude.class);
    }

    private boolean isSetterOverride(Method base, Method override) {
        this.hardAssert(base.getDeclaringClass().isAssignableFrom(override.getDeclaringClass()), "Expected override from a base class");
        this.hardAssert(base.getReturnType().equals(Void.TYPE), "Expected void return type");
        this.hardAssert(override.getReturnType().equals(Void.TYPE), "Expected void return type");
        Class<?>[] baseParameterTypes = base.getParameterTypes();
        Class<?>[] overrideParameterTypes = override.getParameterTypes();
        this.hardAssert(baseParameterTypes.length == 1, "Expected exactly one parameter");
        this.hardAssert(overrideParameterTypes.length == 1, "Expected exactly one parameter");
        return base.getName().equals(override.getName()) && baseParameterTypes[0].equals(overrideParameterTypes[0]);
    }

    private String propertyName(Method method) {
        String annotatedName = this.annotatedName(method);
        return annotatedName != null ? annotatedName : this.serializedName(method.getName());
    }

    private String serializedName(String methodName) {
        String[] prefixes = new String[]{"get", "set", "is"};
        String methodPrefix = null;
        for (String prefix : prefixes) {
            if (!methodName.startsWith(prefix)) continue;
            methodPrefix = prefix;
        }
        if (methodPrefix == null) {
            throw new IllegalArgumentException("Unknown Bean prefix for method: " + methodName);
        }
        String strippedName = methodName.substring(methodPrefix.length());
        char[] chars = strippedName.toCharArray();
        for (int pos = 0; pos < chars.length && Character.isUpperCase(chars[pos]); ++pos) {
            chars[pos] = Character.toLowerCase(chars[pos]);
        }
        return new String(chars);
    }
}

