/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.SnoozeServiceSettings;
import com.google.cloud.monitoring.v3.stub.SnoozeServiceStub;
import com.google.cloud.monitoring.v3.stub.SnoozeServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.CreateSnoozeRequest;
import com.google.monitoring.v3.GetSnoozeRequest;
import com.google.monitoring.v3.ListSnoozesRequest;
import com.google.monitoring.v3.ListSnoozesResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.Snooze;
import com.google.monitoring.v3.SnoozeName;
import com.google.monitoring.v3.UpdateSnoozeRequest;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SnoozeServiceClient
implements BackgroundResource {
    private final SnoozeServiceSettings settings;
    private final SnoozeServiceStub stub;

    public static final SnoozeServiceClient create() throws IOException {
        return SnoozeServiceClient.create(SnoozeServiceSettings.newBuilder().build());
    }

    public static final SnoozeServiceClient create(SnoozeServiceSettings settings) throws IOException {
        return new SnoozeServiceClient(settings);
    }

    public static final SnoozeServiceClient create(SnoozeServiceStub stub) {
        return new SnoozeServiceClient(stub);
    }

    protected SnoozeServiceClient(SnoozeServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SnoozeServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SnoozeServiceClient(SnoozeServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SnoozeServiceSettings getSettings() {
        return this.settings;
    }

    public SnoozeServiceStub getStub() {
        return this.stub;
    }

    public final Snooze createSnooze(ProjectName parent, Snooze snooze) {
        CreateSnoozeRequest request = CreateSnoozeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSnooze(snooze).build();
        return this.createSnooze(request);
    }

    public final Snooze createSnooze(String parent, Snooze snooze) {
        CreateSnoozeRequest request = CreateSnoozeRequest.newBuilder().setParent(parent).setSnooze(snooze).build();
        return this.createSnooze(request);
    }

    public final Snooze createSnooze(CreateSnoozeRequest request) {
        return (Snooze)this.createSnoozeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSnoozeRequest, Snooze> createSnoozeCallable() {
        return this.stub.createSnoozeCallable();
    }

    public final ListSnoozesPagedResponse listSnoozes(ProjectName parent) {
        ListSnoozesRequest request = ListSnoozesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSnoozes(request);
    }

    public final ListSnoozesPagedResponse listSnoozes(String parent) {
        ListSnoozesRequest request = ListSnoozesRequest.newBuilder().setParent(parent).build();
        return this.listSnoozes(request);
    }

    public final ListSnoozesPagedResponse listSnoozes(ListSnoozesRequest request) {
        return (ListSnoozesPagedResponse)((Object)this.listSnoozesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnoozesRequest, ListSnoozesPagedResponse> listSnoozesPagedCallable() {
        return this.stub.listSnoozesPagedCallable();
    }

    public final UnaryCallable<ListSnoozesRequest, ListSnoozesResponse> listSnoozesCallable() {
        return this.stub.listSnoozesCallable();
    }

    public final Snooze getSnooze(SnoozeName name) {
        GetSnoozeRequest request = GetSnoozeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSnooze(request);
    }

    public final Snooze getSnooze(String name) {
        GetSnoozeRequest request = GetSnoozeRequest.newBuilder().setName(name).build();
        return this.getSnooze(request);
    }

    public final Snooze getSnooze(GetSnoozeRequest request) {
        return (Snooze)this.getSnoozeCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnoozeRequest, Snooze> getSnoozeCallable() {
        return this.stub.getSnoozeCallable();
    }

    public final Snooze updateSnooze(Snooze snooze, FieldMask updateMask) {
        UpdateSnoozeRequest request = UpdateSnoozeRequest.newBuilder().setSnooze(snooze).setUpdateMask(updateMask).build();
        return this.updateSnooze(request);
    }

    public final Snooze updateSnooze(UpdateSnoozeRequest request) {
        return (Snooze)this.updateSnoozeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSnoozeRequest, Snooze> updateSnoozeCallable() {
        return this.stub.updateSnoozeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSnoozesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnoozesRequest, ListSnoozesResponse, Snooze, ListSnoozesPage, ListSnoozesFixedSizeCollection> {
        private ListSnoozesFixedSizeCollection(List<ListSnoozesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnoozesFixedSizeCollection createEmptyCollection() {
            return new ListSnoozesFixedSizeCollection(null, 0);
        }

        protected ListSnoozesFixedSizeCollection createCollection(List<ListSnoozesPage> pages, int collectionSize) {
            return new ListSnoozesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnoozesPage
    extends AbstractPage<ListSnoozesRequest, ListSnoozesResponse, Snooze, ListSnoozesPage> {
        private ListSnoozesPage(PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze> context, ListSnoozesResponse response) {
            super(context, (Object)response);
        }

        private static ListSnoozesPage createEmptyPage() {
            return new ListSnoozesPage(null, null);
        }

        protected ListSnoozesPage createPage(PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze> context, ListSnoozesResponse response) {
            return new ListSnoozesPage(context, response);
        }

        public ApiFuture<ListSnoozesPage> createPageAsync(PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze> context, ApiFuture<ListSnoozesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnoozesPagedResponse
    extends AbstractPagedListResponse<ListSnoozesRequest, ListSnoozesResponse, Snooze, ListSnoozesPage, ListSnoozesFixedSizeCollection> {
        public static ApiFuture<ListSnoozesPagedResponse> createAsync(PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze> context, ApiFuture<ListSnoozesResponse> futureResponse) {
            ApiFuture<ListSnoozesPage> futurePage = ListSnoozesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSnoozesPagedResponse((ListSnoozesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSnoozesPagedResponse(ListSnoozesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnoozesFixedSizeCollection.createEmptyCollection());
        }
    }
}

