/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import lombok.Generated;

public class UnexpectedChangeSetsValidator<T extends Liquibase>
implements Consumer<T> {
    private final Contexts contexts;
    private final LabelExpression labelExpression;
    private final Set<ChangeSetInfo> applied;
    private final Set<ChangeSetInfo> unexpected;

    public UnexpectedChangeSetsValidator() {
        this.contexts = new Contexts();
        this.labelExpression = new LabelExpression();
        this.applied = new HashSet<ChangeSetInfo>();
        this.unexpected = new HashSet<ChangeSetInfo>();
    }

    private UnexpectedChangeSetsValidator(Set<ChangeSetInfo> applied, Set<ChangeSetInfo> unexpected, Contexts contexts, LabelExpression labelExpression) {
        this.applied = applied;
        this.unexpected = unexpected;
        this.contexts = contexts;
        this.labelExpression = labelExpression;
    }

    @Override
    public void accept(T liquibase) {
        try {
            ((Liquibase)liquibase).getDatabaseChangeLog().getChangeSets().stream().map(changeSet -> new ChangeSetInfo(changeSet.getId(), changeSet.getFilePath(), changeSet.getAuthor())).forEach(this.applied::add);
            ((Liquibase)liquibase).listUnexpectedChangeSets(this.contexts, this.labelExpression).stream().map(changeSet -> new ChangeSetInfo(changeSet.getId(), changeSet.getChangeLog(), changeSet.getAuthor())).forEach(this.unexpected::add);
        }
        catch (LiquibaseException e) {
            throw new IllegalStateException(e);
        }
    }

    public UnexpectedChangeSetsValidator<T> with(Contexts contexts, LabelExpression labelExpression) {
        return new UnexpectedChangeSetsValidator<T>(this.applied, this.unexpected, contexts, labelExpression);
    }

    public void validate(Consumer<Set<ChangeSetInfo>> unexpectedChangeSetsConsumer) {
        HashSet<ChangeSetInfo> changeSets = new HashSet<ChangeSetInfo>(this.unexpected);
        changeSets.removeAll(this.applied);
        if (!changeSets.isEmpty()) {
            unexpectedChangeSetsConsumer.accept(changeSets);
        }
    }

    public static class ChangeSetInfo {
        private final String id;
        private final String changeLog;
        private final String author;

        public String toString() {
            return this.changeLog + "::" + this.id + "::" + this.author;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getChangeLog() {
            return this.changeLog;
        }

        @Generated
        public String getAuthor() {
            return this.author;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeSetInfo)) {
                return false;
            }
            ChangeSetInfo other = (ChangeSetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$changeLog = this.getChangeLog();
            String other$changeLog = other.getChangeLog();
            if (this$changeLog == null ? other$changeLog != null : !this$changeLog.equals(other$changeLog)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            return !(this$author == null ? other$author != null : !this$author.equals(other$author));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChangeSetInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $changeLog = this.getChangeLog();
            result = result * 59 + ($changeLog == null ? 43 : $changeLog.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            return result;
        }

        @Generated
        public ChangeSetInfo(String id, String changeLog, String author) {
            this.id = id;
            this.changeLog = changeLog;
            this.author = author;
        }
    }
}

