/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.time.OffsetDateTime;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class HoopoProtocolDecoder
extends BaseProtocolDecoder {
    public HoopoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        JsonObject json = Json.createReader((Reader)new StringReader((String)msg)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, json.getString("deviceId"));
        if (deviceSession == null) {
            return null;
        }
        if (json.containsKey((Object)"eventData")) {
            JsonObject eventData = json.getJsonObject("eventData");
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Date time = new Date(OffsetDateTime.parse(json.getString("eventTime")).toInstant().toEpochMilli());
            position.setTime(time);
            position.setValid(true);
            position.setLatitude(eventData.getJsonNumber("latitude").doubleValue());
            position.setLongitude(eventData.getJsonNumber("longitude").doubleValue());
            position.set("event", eventData.getString("eventType"));
            position.set("batteryLevel", eventData.getInt("batteryLevel"));
            if (json.containsKey((Object)"movement")) {
                position.setSpeed(json.getJsonObject("movement").getInt("Speed"));
            }
            return position;
        }
        return null;
    }
}

