/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.heapdump.HeapDump;
import org.graalvm.visualvm.heapdump.impl.HeapDumpCategory;
import org.graalvm.visualvm.heapdump.impl.HeapDumpDescriptorProvider;
import org.graalvm.visualvm.heapdump.impl.HeapDumpProvider;
import org.graalvm.visualvm.heapdump.impl.HeapDumpViewProvider;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

public final class HeapDumpSupport {
    private static HeapDumpSupport instance;
    private final SnapshotCategory<HeapDump> category = new HeapDumpCategory();
    private final HeapDumpProvider heapDumpProvider;
    private final HeapDumpViewProvider heapDumpViewProvider;

    public static synchronized HeapDumpSupport getInstance() {
        if (instance == null) {
            instance = new HeapDumpSupport();
        }
        return instance;
    }

    public SnapshotCategory<HeapDump> getCategory() {
        return this.category;
    }

    public boolean supportsHeapDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isTakeHeapDumpSupported();
    }

    public void takeHeapDump(Application application, boolean openView) {
        this.heapDumpProvider.createHeapDump(application, openView);
    }

    public boolean supportsRemoteHeapDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (application.isLocalApplication()) {
            return false;
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        return jmxModel != null && jmxModel.isTakeHeapDumpSupported();
    }

    public void takeRemoteHeapDump(Application application, String dumpFile, boolean customizeDumpFile) {
        this.heapDumpProvider.createRemoteHeapDump(application, dumpFile, customizeDumpFile);
    }

    public void takeHeapDump(CoreDump coreDump, boolean openView) {
        this.heapDumpProvider.createHeapDump(coreDump, openView);
    }

    public PluggableDataSourceViewProvider<HeapDump> getHeapDumpView() {
        return this.heapDumpViewProvider;
    }

    private HeapDumpSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new HeapDumpDescriptorProvider());
        this.heapDumpProvider = new HeapDumpProvider();
        this.heapDumpProvider.initialize();
        this.heapDumpViewProvider = new HeapDumpViewProvider();
        RegisteredSnapshotCategories.sharedInstance().registerCategory(this.category);
        this.heapDumpViewProvider.initialize();
    }
}

