/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCTypeMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-vc-type-mapper";
    public static final String TYPE_KEY = "vcTypeProperty";
    public static final String DEFAULT_VC_TYPE = "VerifiableCredential";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public boolean includeInMetadata() {
        return Optional.ofNullable((String)this.mapperModel.getConfig().get("vc.include_in_metadata")).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public List<String> getMetadataAttributePath() {
        return List.of("type");
    }

    @Override
    public void setClaim(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
        HashSet<String> types = new HashSet<String>();
        if (verifiableCredential.getType() != null) {
            types = new HashSet<String>(verifiableCredential.getType());
        }
        types.add(Optional.ofNullable((String)this.mapperModel.getConfig().get(TYPE_KEY)).orElse(DEFAULT_VC_TYPE));
        verifiableCredential.setType(new ArrayList<String>(types));
    }

    @Override
    public void setClaim(Map<String, Object> claims, UserSessionModel userSessionModel) {
    }

    public String getDisplayType() {
        return "Credential Type Mapper";
    }

    public String getHelpText() {
        return "Assigns a type to the credential.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCTypeMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty vcTypePropertyNameConfig = new ProviderConfigProperty();
        vcTypePropertyNameConfig.setName(TYPE_KEY);
        vcTypePropertyNameConfig.setLabel("Verifiable Credential Type");
        vcTypePropertyNameConfig.setHelpText("Type of the credential.");
        vcTypePropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(vcTypePropertyNameConfig);
    }
}

