<?php
/**
 * TemplatesService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * TemplatesService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TemplatesService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation applyTemplate
     *
     * Apply or dry-run a template
     *
     * @param  \InfluxDB2\Model\TemplateApply $template_apply Parameters for applying templates. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\TemplateSummary|\InfluxDB2\Model\TemplateSummary|TemplateSummary|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function applyTemplate($template_apply)
    {
        list($response) = $this->applyTemplateWithHttpInfo($template_apply);
        return $response;
    }

    /**
     * Operation applyTemplateWithHttpInfo
     *
     * Apply or dry-run a template
     *
     * @param  \InfluxDB2\Model\TemplateApply $template_apply Parameters for applying templates. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\TemplateSummary|\InfluxDB2\Model\TemplateSummary|TemplateSummary|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function applyTemplateWithHttpInfo($template_apply)
    {
        $request = $this->applyTemplateRequest($template_apply);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\TemplateSummary';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'applyTemplate'
     *
     * @param  \InfluxDB2\Model\TemplateApply $template_apply Parameters for applying templates. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function applyTemplateRequest($template_apply)
    {
        // verify the required parameter 'template_apply' is set
        if ($template_apply === null || (is_array($template_apply) && count($template_apply) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $template_apply when calling applyTemplate'
            );
        }

        $resourcePath = '/api/v2/templates/apply';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($template_apply)) {
            $_tempBody = $template_apply;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json', 'application/x-jsonnet', 'text/yml']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation createStack
     *
     * Create a stack
     *
     * @param  \InfluxDB2\Model\PostStackRequest1 $post_stack_request1 post_stack_request1 (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Stack|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function createStack($post_stack_request1 = null)
    {
        list($response) = $this->createStackWithHttpInfo($post_stack_request1);
        return $response;
    }

    /**
     * Operation createStackWithHttpInfo
     *
     * Create a stack
     *
     * @param  \InfluxDB2\Model\PostStackRequest1 $post_stack_request1 (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Stack|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createStackWithHttpInfo($post_stack_request1 = null)
    {
        $request = $this->createStackRequest($post_stack_request1);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Stack';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'createStack'
     *
     * @param  \InfluxDB2\Model\PostStackRequest1 $post_stack_request1 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function createStackRequest($post_stack_request1 = null)
    {

        $resourcePath = '/api/v2/stacks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($post_stack_request1)) {
            $_tempBody = $post_stack_request1;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteStack
     *
     * Delete a stack and associated resources
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  string $org_id The identifier of the organization. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteStack($stack_id, $org_id)
    {
        $this->deleteStackWithHttpInfo($stack_id, $org_id);
    }

    /**
     * Operation deleteStackWithHttpInfo
     *
     * Delete a stack and associated resources
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  string $org_id The identifier of the organization. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteStackWithHttpInfo($stack_id, $org_id)
    {
        $request = $this->deleteStackRequest($stack_id, $org_id);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteStack'
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  string $org_id The identifier of the organization. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteStackRequest($stack_id, $org_id)
    {
        // verify the required parameter 'stack_id' is set
        if ($stack_id === null || (is_array($stack_id) && count($stack_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stack_id when calling deleteStack'
            );
        }
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteStack'
            );
        }

        $resourcePath = '/api/v2/stacks/{stack_id}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }

        // path params
        if ($stack_id !== null) {
            $resourcePath = str_replace(
                '{' . 'stack_id' . '}',
                ObjectSerializer::toPathValue($stack_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation exportTemplate
     *
     * Export a new template
     *
     * @param  \InfluxDB2\Model\TemplateExportByID $template_export_by_id Export resources as an InfluxDB template. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return object[]|\InfluxDB2\Model\Error
     */
    public function exportTemplate($template_export_by_id = null)
    {
        list($response) = $this->exportTemplateWithHttpInfo($template_export_by_id);
        return $response;
    }

    /**
     * Operation exportTemplateWithHttpInfo
     *
     * Export a new template
     *
     * @param  \InfluxDB2\Model\TemplateExportByID $template_export_by_id Export resources as an InfluxDB template. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of object[]|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportTemplateWithHttpInfo($template_export_by_id = null)
    {
        $request = $this->exportTemplateRequest($template_export_by_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'object[]';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'exportTemplate'
     *
     * @param  \InfluxDB2\Model\TemplateExportByID $template_export_by_id Export resources as an InfluxDB template. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function exportTemplateRequest($template_export_by_id = null)
    {

        $resourcePath = '/api/v2/templates/export';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($template_export_by_id)) {
            $_tempBody = $template_export_by_id;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', 'application/x-yaml']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', 'application/x-yaml'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation listStacks
     *
     * List installed stacks
     *
     * @param  string $org_id The ID of the organization that owns the stacks. Only returns stacks owned by this organization.  #### InfluxDB Cloud  - Doesn&#39;t require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
     * @param  string $name The stack name. Finds stack &#x60;events&#x60; with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;name&#x3D;project-stack-0&amp;name&#x3D;project-stack-1&#x60; (optional)
     * @param  string $stack_id The stack ID. Only returns stacks with this ID.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;stackID&#x3D;09bd87cd33be3000&amp;stackID&#x3D;09bef35081fe3000&#x60; (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ListStacksResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function listStacks($org_id, $name = null, $stack_id = null)
    {
        list($response) = $this->listStacksWithHttpInfo($org_id, $name, $stack_id);
        return $response;
    }

    /**
     * Operation listStacksWithHttpInfo
     *
     * List installed stacks
     *
     * @param  string $org_id The ID of the organization that owns the stacks. Only returns stacks owned by this organization.  #### InfluxDB Cloud  - Doesn&#39;t require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
     * @param  string $name The stack name. Finds stack &#x60;events&#x60; with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;name&#x3D;project-stack-0&amp;name&#x3D;project-stack-1&#x60; (optional)
     * @param  string $stack_id The stack ID. Only returns stacks with this ID.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;stackID&#x3D;09bd87cd33be3000&amp;stackID&#x3D;09bef35081fe3000&#x60; (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ListStacksResponse|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function listStacksWithHttpInfo($org_id, $name = null, $stack_id = null)
    {
        $request = $this->listStacksRequest($org_id, $name, $stack_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ListStacksResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'listStacks'
     *
     * @param  string $org_id The ID of the organization that owns the stacks. Only returns stacks owned by this organization.  #### InfluxDB Cloud  - Doesn&#39;t require this parameter;   InfluxDB only returns resources allowed by the API token. (required)
     * @param  string $name The stack name. Finds stack &#x60;events&#x60; with this name and returns the stacks.  Repeatable. To filter for more than one stack name, repeat this parameter with each name--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;name&#x3D;project-stack-0&amp;name&#x3D;project-stack-1&#x60; (optional)
     * @param  string $stack_id The stack ID. Only returns stacks with this ID.  Repeatable. To filter for more than one stack ID, repeat this parameter with each ID--for example:  - &#x60;http://localhost:8086/api/v2/stacks?&amp;orgID&#x3D;INFLUX_ORG_ID&amp;stackID&#x3D;09bd87cd33be3000&amp;stackID&#x3D;09bef35081fe3000&#x60; (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function listStacksRequest($org_id, $name = null, $stack_id = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling listStacks'
            );
        }

        $resourcePath = '/api/v2/stacks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if ($stack_id !== null) {
            $queryParams['stackID'] = ObjectSerializer::toQueryValue($stack_id);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation readStack
     *
     * Retrieve a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error
     */
    public function readStack($stack_id)
    {
        list($response) = $this->readStackWithHttpInfo($stack_id);
        return $response;
    }

    /**
     * Operation readStackWithHttpInfo
     *
     * Retrieve a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readStackWithHttpInfo($stack_id)
    {
        $request = $this->readStackRequest($stack_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Stack';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'readStack'
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function readStackRequest($stack_id)
    {
        // verify the required parameter 'stack_id' is set
        if ($stack_id === null || (is_array($stack_id) && count($stack_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stack_id when calling readStack'
            );
        }

        $resourcePath = '/api/v2/stacks/{stack_id}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($stack_id !== null) {
            $resourcePath = str_replace(
                '{' . 'stack_id' . '}',
                ObjectSerializer::toPathValue($stack_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation uninstallStack
     *
     * Uninstall a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error
     */
    public function uninstallStack($stack_id)
    {
        list($response) = $this->uninstallStackWithHttpInfo($stack_id);
        return $response;
    }

    /**
     * Operation uninstallStackWithHttpInfo
     *
     * Uninstall a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function uninstallStackWithHttpInfo($stack_id)
    {
        $request = $this->uninstallStackRequest($stack_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Stack';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'uninstallStack'
     *
     * @param  string $stack_id The identifier of the stack. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function uninstallStackRequest($stack_id)
    {
        // verify the required parameter 'stack_id' is set
        if ($stack_id === null || (is_array($stack_id) && count($stack_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stack_id when calling uninstallStack'
            );
        }

        $resourcePath = '/api/v2/stacks/{stack_id}/uninstall';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($stack_id !== null) {
            $resourcePath = str_replace(
                '{' . 'stack_id' . '}',
                ObjectSerializer::toPathValue($stack_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation updateStack
     *
     * Update a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  \InfluxDB2\Model\PatchStackRequest1 $patch_stack_request1 patch_stack_request1 (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error
     */
    public function updateStack($stack_id, $patch_stack_request1 = null)
    {
        list($response) = $this->updateStackWithHttpInfo($stack_id, $patch_stack_request1);
        return $response;
    }

    /**
     * Operation updateStackWithHttpInfo
     *
     * Update a stack
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  \InfluxDB2\Model\PatchStackRequest1 $patch_stack_request1 (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Stack|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateStackWithHttpInfo($stack_id, $patch_stack_request1 = null)
    {
        $request = $this->updateStackRequest($stack_id, $patch_stack_request1);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Stack';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'updateStack'
     *
     * @param  string $stack_id The identifier of the stack. (required)
     * @param  \InfluxDB2\Model\PatchStackRequest1 $patch_stack_request1 (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function updateStackRequest($stack_id, $patch_stack_request1 = null)
    {
        // verify the required parameter 'stack_id' is set
        if ($stack_id === null || (is_array($stack_id) && count($stack_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stack_id when calling updateStack'
            );
        }

        $resourcePath = '/api/v2/stacks/{stack_id}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($stack_id !== null) {
            $resourcePath = str_replace(
                '{' . 'stack_id' . '}',
                ObjectSerializer::toPathValue($stack_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($patch_stack_request1)) {
            $_tempBody = $patch_stack_request1;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
