/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFXUtil;

public class OpenALInfo {
    protected void execute(String[] args) {
        try {
            AL.create(null, (int)-1, (int)60, (boolean)false);
            this.checkForErrors();
        }
        catch (LWJGLException le) {
            this.die("Init", le.getMessage());
        }
        this.printALCInfo();
        this.printALInfo();
        this.printEFXInfo();
        this.checkForErrors();
        AL.destroy();
    }

    private void printALCInfo() {
        String[] extensions;
        IntBuffer version = BufferUtils.createIntBuffer((int)2);
        if (ALC10.alcIsExtensionPresent(null, (String)"ALC_ENUMERATION_EXT")) {
            if (ALC10.alcIsExtensionPresent(null, (String)"ALC_ENUMERATE_ALL_EXT")) {
                this.printDevices(4115, "playback");
            } else {
                this.printDevices(4101, "playback");
            }
            this.printDevices(784, "capture");
        } else {
            System.out.println("No device enumeration available");
        }
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)ALC10.alcGetCurrentContext());
        this.checkForErrors();
        System.out.println("Default playback device: " + ALC10.alcGetString((ALCdevice)device, (int)4100));
        System.out.println("Default capture device: " + ALC10.alcGetString((ALCdevice)device, (int)785));
        ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4096, (IntBuffer)version);
        ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4097, (IntBuffer)version.position(1));
        this.checkForErrors();
        System.out.println("ALC version: " + version.get(0) + "." + version.get(1));
        System.out.println("ALC extensions:");
        for (String extension : extensions = ALC10.alcGetString((ALCdevice)device, (int)4102).split(" ")) {
            if (extension.trim().length() == 0) continue;
            System.out.println("    " + extension);
        }
        this.checkForErrors();
    }

    private void printALInfo() {
        String[] extensions;
        System.out.println("OpenAL vendor string: " + AL10.alGetString((int)45057));
        System.out.println("OpenAL renderer string: " + AL10.alGetString((int)45059));
        System.out.println("OpenAL version string: " + AL10.alGetString((int)45058));
        System.out.println("AL extensions:");
        for (String extension : extensions = AL10.alGetString((int)45060).split(" ")) {
            if (extension.trim().length() == 0) continue;
            System.out.println("    " + extension);
        }
        this.checkForErrors();
    }

    private void printEFXInfo() {
        if (!EFXUtil.isEfxSupported()) {
            System.out.println("EFX not available");
            return;
        }
        ALCdevice device = AL.getDevice();
        IntBuffer major = BufferUtils.createIntBuffer((int)1);
        IntBuffer minor = BufferUtils.createIntBuffer((int)1);
        IntBuffer sends = BufferUtils.createIntBuffer((int)1);
        ALC10.alcGetInteger((ALCdevice)device, (int)131073, (IntBuffer)major);
        ALC10.alcGetInteger((ALCdevice)device, (int)131074, (IntBuffer)minor);
        if (ALC10.alcGetError((ALCdevice)device) == 0) {
            System.out.println("EFX version: " + major.get() + "." + minor.get());
        }
        ALC10.alcGetInteger((ALCdevice)device, (int)131075, (IntBuffer)sends);
        if (ALC10.alcGetError((ALCdevice)device) == 0) {
            System.out.println("Max auxiliary sends: " + sends.get());
        }
        System.out.println("Supported filters: ");
        HashMap<String, Integer> filters = new HashMap<String, Integer>();
        filters.put("Low-pass", 1);
        filters.put("High-pass", 2);
        filters.put("Band-pass", 3);
        Set entries = filters.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!EFXUtil.isFilterSupported((int)((Integer)entry.getValue()))) continue;
            System.out.println("    " + (String)entry.getKey());
        }
        System.out.println("Supported effects: ");
        HashMap<String, Integer> effects = new HashMap<String, Integer>();
        effects.put("EAX Reverb", 32768);
        effects.put("Reverb", 1);
        effects.put("Chorus", 2);
        effects.put("Distortion", 3);
        effects.put("Echo", 4);
        effects.put("Flanger", 5);
        effects.put("Frequency Shifter", 6);
        effects.put("Vocal Morpher", 7);
        effects.put("Pitch Shifter", 8);
        effects.put("Ring Modulator", 9);
        effects.put("Autowah", 10);
        effects.put("Compressor", 11);
        effects.put("Equalizer", 12);
        entries = effects.entrySet();
        for (Map.Entry entry : entries) {
            if (!EFXUtil.isEffectSupported((int)((Integer)entry.getValue()))) continue;
            System.out.println("    " + (String)entry.getKey());
        }
    }

    private void printDevices(int which, String kind) {
        String[] devices = ALC10.alcGetString(null, (int)which).split("\u0000");
        this.checkForErrors();
        System.out.println("Available " + kind + " devices: ");
        for (String device : devices) {
            System.out.println("    " + device);
        }
    }

    private void die(String kind, String description) {
        System.out.println(kind + " error " + description + " occured");
    }

    private void checkForErrors() {
        int error;
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)ALC10.alcGetCurrentContext());
        int error2 = ALC10.alcGetError((ALCdevice)device);
        if (error2 != 0) {
            this.die("ALC", ALC10.alcGetString((ALCdevice)device, (int)error2));
        }
        if ((error = AL10.alGetError()) != 0) {
            this.die("AL", AL10.alGetString((int)error));
        }
    }

    public static void main(String[] args) {
        OpenALInfo openalInfo = new OpenALInfo();
        openalInfo.execute(args);
        System.exit(0);
    }
}

