/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkLayerProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAYERNAME;
    public static final int SPECVERSION;
    public static final int IMPLEMENTATIONVERSION;
    public static final int DESCRIPTION;

    public VkLayerProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkLayerProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer layerName() {
        return VkLayerProperties.nlayerName(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String layerNameString() {
        return VkLayerProperties.nlayerNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int specVersion() {
        return VkLayerProperties.nspecVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int implementationVersion() {
        return VkLayerProperties.nimplementationVersion(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return VkLayerProperties.ndescription(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return VkLayerProperties.ndescriptionString(this.address());
    }

    public static VkLayerProperties malloc() {
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkLayerProperties calloc() {
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkLayerProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkLayerProperties create(long address) {
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)address);
    }

    @Nullable
    public static VkLayerProperties createSafe(long address) {
        return address == 0L ? null : (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkLayerProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkLayerProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkLayerProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkLayerProperties mallocStack() {
        return VkLayerProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkLayerProperties callocStack() {
        return VkLayerProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkLayerProperties mallocStack(MemoryStack stack) {
        return VkLayerProperties.malloc(stack);
    }

    @Deprecated
    public static VkLayerProperties callocStack(MemoryStack stack) {
        return VkLayerProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkLayerProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkLayerProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.calloc(capacity, stack);
    }

    public static VkLayerProperties malloc(MemoryStack stack) {
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkLayerProperties calloc(MemoryStack stack) {
        return (VkLayerProperties)VkLayerProperties.wrap(VkLayerProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkLayerProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nlayerName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LAYERNAME), (int)256);
    }

    public static String nlayerNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)LAYERNAME));
    }

    public static int nspecVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPECVERSION);
    }

    public static int nimplementationVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMPLEMENTATIONVERSION);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DESCRIPTION), (int)256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DESCRIPTION));
    }

    static {
        Struct.Layout layout = VkLayerProperties.__struct((Struct.Member[])new Struct.Member[]{VkLayerProperties.__array((int)1, (int)256), VkLayerProperties.__member((int)4), VkLayerProperties.__member((int)4), VkLayerProperties.__array((int)1, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAYERNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
        IMPLEMENTATIONVERSION = layout.offsetof(2);
        DESCRIPTION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkLayerProperties, Buffer>
    implements NativeResource {
        private static final VkLayerProperties ELEMENT_FACTORY = VkLayerProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkLayerProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer layerName() {
            return VkLayerProperties.nlayerName(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String layerNameString() {
            return VkLayerProperties.nlayerNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int specVersion() {
            return VkLayerProperties.nspecVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int implementationVersion() {
            return VkLayerProperties.nimplementationVersion(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return VkLayerProperties.ndescription(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return VkLayerProperties.ndescriptionString(this.address());
        }
    }
}

