/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRResources {
    protected VRResources() {
        throw new UnsupportedOperationException();
    }

    public static int nVRResources_LoadSharedResource(long pchResourceName, long pchBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.LoadSharedResource;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchResourceName, (long)pchBuffer, (int)unBufferLen, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRResources_LoadSharedResource(@NativeType(value="char const *") ByteBuffer pchResourceName, @Nullable @NativeType(value="char *") ByteBuffer pchBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchResourceName);
        }
        return VRResources.nVRResources_LoadSharedResource(MemoryUtil.memAddress((ByteBuffer)pchResourceName), MemoryUtil.memAddressSafe((ByteBuffer)pchBuffer), Checks.remainingSafe((Buffer)pchBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRResources_LoadSharedResource(@NativeType(value="char const *") CharSequence pchResourceName, @Nullable @NativeType(value="char *") ByteBuffer pchBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            int n = VRResources.nVRResources_LoadSharedResource(pchResourceNameEncoded, MemoryUtil.memAddressSafe((ByteBuffer)pchBuffer), Checks.remainingSafe((Buffer)pchBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRResources_LoadSharedResource(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="uint32_t") int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            ByteBuffer pchBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_LoadSharedResource(pchResourceNameEncoded, MemoryUtil.memAddress((ByteBuffer)pchBuffer), unBufferLen);
            String string = MemoryUtil.memASCII((ByteBuffer)pchBuffer, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRResources_GetResourceFullPath(long pchResourceName, long pchResourceTypeDirectory, long pchPathBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.GetResourceFullPath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pchResourceName, (long)pchResourceTypeDirectory, (long)pchPathBuffer, (int)unBufferLen, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRResources_GetResourceFullPath(@NativeType(value="char const *") ByteBuffer pchResourceName, @NativeType(value="char const *") ByteBuffer pchResourceTypeDirectory, @Nullable @NativeType(value="char *") ByteBuffer pchPathBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchResourceName);
            Checks.checkNT1((ByteBuffer)pchResourceTypeDirectory);
        }
        return VRResources.nVRResources_GetResourceFullPath(MemoryUtil.memAddress((ByteBuffer)pchResourceName), MemoryUtil.memAddress((ByteBuffer)pchResourceTypeDirectory), MemoryUtil.memAddressSafe((ByteBuffer)pchPathBuffer), Checks.remainingSafe((Buffer)pchPathBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRResources_GetResourceFullPath(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="char const *") CharSequence pchResourceTypeDirectory, @Nullable @NativeType(value="char *") ByteBuffer pchPathBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchResourceTypeDirectory, true);
            long pchResourceTypeDirectoryEncoded = stack.getPointerAddress();
            int n = VRResources.nVRResources_GetResourceFullPath(pchResourceNameEncoded, pchResourceTypeDirectoryEncoded, MemoryUtil.memAddressSafe((ByteBuffer)pchPathBuffer), Checks.remainingSafe((Buffer)pchPathBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRResources_GetResourceFullPath(@NativeType(value="char const *") CharSequence pchResourceName, @NativeType(value="char const *") CharSequence pchResourceTypeDirectory, @NativeType(value="uint32_t") int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchResourceName, true);
            long pchResourceNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchResourceTypeDirectory, true);
            long pchResourceTypeDirectoryEncoded = stack.getPointerAddress();
            ByteBuffer pchPathBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_GetResourceFullPath(pchResourceNameEncoded, pchResourceTypeDirectoryEncoded, MemoryUtil.memAddress((ByteBuffer)pchPathBuffer), unBufferLen);
            String string = MemoryUtil.memASCII((ByteBuffer)pchPathBuffer, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

